/*
 * Decompiled with CFR 0.152.
 */
package org.ufoss.kotysa.android;

import android.database.Cursor;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ufoss.kotysa.Row;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J/\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/ufoss/kotysa/android/SqLiteRow;", "Lorg/ufoss/kotysa/Row;", "sqLiteCursor", "Landroid/database/Cursor;", "(Landroid/database/Cursor;)V", "get", "T", "", "index", "", "clazz", "Ljava/lang/Class;", "(ILjava/lang/Class;)Ljava/lang/Object;", "kotysa-android"})
public final class SqLiteRow
implements Row {
    @NotNull
    private final Cursor sqLiteCursor;

    public SqLiteRow(@NotNull Cursor sqLiteCursor) {
        Intrinsics.checkNotNullParameter((Object)sqLiteCursor, (String)"sqLiteCursor");
        this.sqLiteCursor = sqLiteCursor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public <T> T get(int index, @NotNull Class<T> clazz) {
        Object object;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (this.sqLiteCursor.isNull(index)) {
            object = null;
            return (T)object;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            object = this.sqLiteCursor.getInt(index);
            return (T)object;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            object = this.sqLiteCursor.getLong(index);
            return (T)object;
        }
        if (Float.class.isAssignableFrom(clazz)) {
            object = Float.valueOf(this.sqLiteCursor.getFloat(index));
            return (T)object;
        }
        if (Short.class.isAssignableFrom(clazz)) {
            object = this.sqLiteCursor.getShort(index);
            return (T)object;
        }
        if (Double.class.isAssignableFrom(clazz)) {
            object = this.sqLiteCursor.getDouble(index);
            return (T)object;
        }
        if (String.class.isAssignableFrom(clazz)) {
            object = this.sqLiteCursor.getString(index);
            return (T)object;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            object = this.sqLiteCursor.getInt(index) != 0;
            return (T)object;
        }
        if (byte[].class.isAssignableFrom(clazz)) {
            object = this.sqLiteCursor.getBlob(index);
            return (T)object;
        }
        if (LocalDate.class.isAssignableFrom(clazz)) {
            object = LocalDate.parse(this.sqLiteCursor.getString(index));
            return (T)object;
        }
        if (LocalDateTime.class.isAssignableFrom(clazz)) {
            object = LocalDateTime.parse(this.sqLiteCursor.getString(index));
            return (T)object;
        }
        if (OffsetDateTime.class.isAssignableFrom(clazz)) {
            object = OffsetDateTime.parse(this.sqLiteCursor.getString(index));
            return (T)object;
        }
        if (LocalTime.class.isAssignableFrom(clazz)) {
            object = LocalTime.parse(this.sqLiteCursor.getString(index));
            return (T)object;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            object = new BigDecimal(String.valueOf(this.sqLiteCursor.getDouble(index)));
            return (T)object;
        }
        String string = clazz.getName();
        if (string == null) throw new UnsupportedOperationException(clazz.getCanonicalName() + " is not supported by Android SqLite");
        int n = -1;
        switch (string.hashCode()) {
            case -61177187: {
                if (string.equals("kotlinx.datetime.LocalDate")) {
                    n = 1;
                }
                break;
            }
            case -60693060: {
                if (string.equals("kotlinx.datetime.LocalTime")) {
                    n = 2;
                }
                break;
            }
            case 1880470282: {
                if (string.equals("kotlinx.datetime.LocalDateTime")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                String string2 = this.sqLiteCursor.getString(index);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sqLiteCursor.getString(index)");
                object = (Comparable)kotlinx.datetime.LocalDate.Companion.parse(string2);
                return (T)object;
            }
            case 3: {
                String string3 = this.sqLiteCursor.getString(index);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sqLiteCursor.getString(index)");
                object = (Comparable)kotlinx.datetime.LocalDateTime.Companion.parse(string3);
                return (T)object;
            }
            case 2: {
                String string4 = this.sqLiteCursor.getString(index);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"sqLiteCursor.getString(index)");
                object = (Comparable)kotlinx.datetime.LocalTime.Companion.parse(string4);
                return (T)object;
            }
            default: {
                throw new UnsupportedOperationException(clazz.getCanonicalName() + " is not supported by Android SqLite");
            }
        }
    }
}

