/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import org.jboss.errai.common.client.dom.CSSStyleDeclaration;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.Button;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.client.views.pfly.widgets.InlineNotification;
import org.uberfire.client.views.pfly.widgets.Modal;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfirmPopupTest {
    private static final String TITLE = "TITLE";
    private static final String INLINE_NOTIFICATION_MESSAGE = "INLINE_NOTIFICATION_MESSAGE";
    private static final String CONFIRM_MESSAGE = "CONFIRM_MESSAGE";
    private static final String OK_BUTTON_TEXT = "OK_BUTTON_TEXT";
    @Mock
    Modal modal;
    @Mock
    Span modalTitle;
    @Mock
    InlineNotification confirmInlineNotification;
    @Mock
    HTMLElement confirmInlineNotificationElement;
    @Mock
    CSSStyleDeclaration confirmInlineNotificationStyle;
    @Mock
    Span modalConfirmationMessageLabel;
    @Mock
    Button okButton;
    @Mock
    Button cancelButton;
    @InjectMocks
    ConfirmPopup popup;

    @Before
    public void setUp() {
        Mockito.when((Object)this.confirmInlineNotification.getElement()).thenReturn((Object)this.confirmInlineNotificationElement);
        Mockito.when((Object)this.confirmInlineNotificationElement.getStyle()).thenReturn((Object)this.confirmInlineNotificationStyle);
    }

    @Test
    public void testHide() {
        this.popup.hide();
        ((Modal)Mockito.verify((Object)this.modal)).hide();
    }

    @Test
    public void testCancel() {
        this.popup.onCancelClick(null);
        ((Modal)Mockito.verify((Object)this.modal)).hide();
    }

    @Test
    public void testClose() {
        this.popup.onCloseClick(null);
        ((Modal)Mockito.verify((Object)this.modal)).hide();
    }

    @Test
    public void testOk() {
        Command command = (Command)Mockito.mock(Command.class);
        this.popup.show(null, null, null, command);
        this.popup.onOkClick(null);
        ((Command)Mockito.verify((Object)command)).execute();
        ((Modal)Mockito.verify((Object)this.modal)).hide();
    }

    @Test
    public void testShow() {
        Command command = (Command)Mockito.mock(Command.class);
        this.popup.show(TITLE, OK_BUTTON_TEXT, CONFIRM_MESSAGE, command);
        ((Span)Mockito.verify((Object)this.modalTitle, (VerificationMode)Mockito.times((int)1))).setTextContent(TITLE);
        ((CSSStyleDeclaration)Mockito.verify((Object)this.confirmInlineNotificationStyle, (VerificationMode)Mockito.times((int)1))).setProperty("display", "none");
        ((Button)Mockito.verify((Object)this.okButton, (VerificationMode)Mockito.times((int)1))).setText(OK_BUTTON_TEXT);
        ((Button)Mockito.verify((Object)this.okButton, (VerificationMode)Mockito.times((int)1))).setButtonStyleType(Button.ButtonStyleType.DANGER);
        ((Span)Mockito.verify((Object)this.modalConfirmationMessageLabel, (VerificationMode)Mockito.times((int)1))).setTextContent(CONFIRM_MESSAGE);
    }

    @Test
    public void testShowWithInlineNotification() {
        Command command = (Command)Mockito.mock(Command.class);
        InlineNotification.InlineNotificationType arbitraryNotificationType = InlineNotification.InlineNotificationType.WARNING;
        Button.ButtonStyleType arbitraryButtonType = Button.ButtonStyleType.PRIMARY;
        this.popup.show(TITLE, INLINE_NOTIFICATION_MESSAGE, arbitraryNotificationType, OK_BUTTON_TEXT, arbitraryButtonType, CONFIRM_MESSAGE, command);
        ((Span)Mockito.verify((Object)this.modalTitle, (VerificationMode)Mockito.times((int)1))).setTextContent(TITLE);
        ((CSSStyleDeclaration)Mockito.verify((Object)this.confirmInlineNotificationStyle, (VerificationMode)Mockito.times((int)1))).removeProperty("display");
        ((InlineNotification)Mockito.verify((Object)this.confirmInlineNotification, (VerificationMode)Mockito.times((int)1))).setMessage(INLINE_NOTIFICATION_MESSAGE);
        ((InlineNotification)Mockito.verify((Object)this.confirmInlineNotification, (VerificationMode)Mockito.times((int)1))).setType(arbitraryNotificationType);
        ((Button)Mockito.verify((Object)this.okButton, (VerificationMode)Mockito.times((int)1))).setText(OK_BUTTON_TEXT);
        ((Button)Mockito.verify((Object)this.okButton, (VerificationMode)Mockito.times((int)1))).setButtonStyleType(arbitraryButtonType);
        ((Span)Mockito.verify((Object)this.modalConfirmationMessageLabel, (VerificationMode)Mockito.times((int)1))).setTextContent(CONFIRM_MESSAGE);
    }
}

