/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.multiscreen;

import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLElement;
import java.util.Optional;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.client.views.pfly.multiscreen.MultiScreenMenuBuilder;
import org.uberfire.client.views.pfly.widgets.Button;
import org.uberfire.client.views.pfly.widgets.KebabMenu;
import org.uberfire.client.views.pfly.widgets.KebabMenuItem;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;

@RunWith(value=MockitoJUnitRunner.class)
public class MultiScreenMenuBuilderTest {
    @Mock
    AuthorizationManager authManager;
    @Mock
    User identity;
    @Mock
    HTMLDocument document;
    @Mock
    ManagedInstance<KebabMenu> kebabMenus;
    @Mock
    ManagedInstance<KebabMenuItem> kebabMenuItems;
    @Mock
    ManagedInstance<Button> buttons;
    @InjectMocks
    MultiScreenMenuBuilder menuBuilder;

    @Before
    public void setup() {
        Mockito.when((Object)this.authManager.authorize((Resource)Mockito.any(Resource.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true);
        Button button = (Button)Mockito.mock(Button.class);
        Mockito.when((Object)button.getElement()).thenReturn((Object)((HTMLElement)Mockito.mock(HTMLButtonElement.class)));
        Mockito.when((Object)((Button)this.buttons.get())).thenReturn((Object)button);
        Mockito.when((Object)((KebabMenu)this.kebabMenus.get())).thenReturn((Object)((KebabMenu)Mockito.mock(KebabMenu.class)));
    }

    @Test
    public void testDeniedPermission() {
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        Mockito.when((Object)this.authManager.authorize((Resource)Mockito.any(Resource.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)false);
        Optional optional = this.menuBuilder.apply(menuItem);
        Assert.assertFalse((boolean)optional.isPresent());
        ((AuthorizationManager)Mockito.verify((Object)this.authManager)).authorize((Resource)menuItem, this.identity);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.kebabMenus, this.document});
    }

    @Test
    public void testAllowedPermission() {
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        Mockito.when((Object)this.authManager.authorize((Resource)Mockito.any(Resource.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)false);
        Mockito.when((Object)this.authManager.authorize((Resource)menuItem, this.identity)).thenReturn((Object)true);
        Optional optional = this.menuBuilder.apply(menuItem);
        Assert.assertFalse((boolean)optional.isPresent());
        ((AuthorizationManager)Mockito.verify((Object)this.authManager)).authorize((Resource)menuItem, this.identity);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.kebabMenus, this.document});
    }

    @Test
    public void testMenuItemCommand() {
        MenuItemCommand menuItem = (MenuItemCommand)Mockito.mock(MenuItemCommand.class);
        Optional optional = this.menuBuilder.apply((MenuItem)menuItem);
        Assert.assertTrue((boolean)optional.isPresent());
        ((ManagedInstance)Mockito.verify(this.buttons)).get();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.kebabMenus});
    }

    @Test
    public void testMenuGroup() {
        KebabMenu kebabMenu = (KebabMenu)Mockito.mock(KebabMenu.class);
        Mockito.when((Object)kebabMenu.getElement()).thenReturn((Object)((HTMLElement)Mockito.mock(HTMLDivElement.class)));
        Mockito.when((Object)((KebabMenu)this.kebabMenus.get())).thenReturn((Object)kebabMenu);
        MenuGroup menuItem = (MenuGroup)Mockito.mock(MenuGroup.class);
        Optional optional = this.menuBuilder.apply((MenuItem)menuItem);
        Assert.assertTrue((boolean)optional.isPresent());
        ((ManagedInstance)Mockito.verify(this.kebabMenus)).get();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.document});
    }

    @Test
    public void testMenuCustom() {
        MenuCustom menuItem = (MenuCustom)Mockito.mock(MenuCustom.class);
        Mockito.when((Object)menuItem.build()).thenReturn(Mockito.mock(HTMLElement.class));
        Optional optional = this.menuBuilder.apply((MenuItem)menuItem);
        Assert.assertTrue((boolean)optional.isPresent());
        ((MenuCustom)Mockito.verify((Object)menuItem)).build();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.kebabMenus, this.document});
    }
}

