/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import org.apache.commons.lang3.RandomStringUtils;
import org.gwtbootstrap3.client.ui.AnchorButton;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.DropDownHeader;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.ListDropDown;
import org.gwtbootstrap3.client.ui.NavbarNav;
import org.gwtbootstrap3.client.ui.html.Text;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.menu.WorkbenchMenuCompactNavBarView;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuPosition;

@RunWith(value=GwtMockitoTestRunner.class)
public class WorkbenchMenuCompactNavBarViewTest {
    @InjectMocks
    WorkbenchMenuCompactNavBarView workbenchMenuCompactNavBarView;
    @GwtMock
    NavbarNav navbarNav;
    @GwtMock
    AnchorListItem anchorListItem;
    @GwtMock
    ListDropDown listDropDown;
    @GwtMock
    AnchorButton anchorButton;
    @GwtMock
    DropDownMenu dropDownMenu;
    @GwtMock
    DropDownHeader dropDownHeader;
    @GwtMock
    Text text;

    @Test
    public void testAddMenuItem() {
        String menuId = RandomStringUtils.random((int)10);
        String menuParentId = null;
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        Command command = (Command)Mockito.mock(Command.class);
        this.workbenchMenuCompactNavBarView.addMenuItem(menuId, label, menuParentId, command, position);
        ((DropDownMenu)Mockito.verify((Object)this.dropDownMenu)).add((Widget)this.anchorListItem);
        ((AnchorListItem)Mockito.verify((Object)this.anchorListItem)).setText(label);
        Assert.assertEquals((Object)this.anchorListItem, this.workbenchMenuCompactNavBarView.getMenuItemWidgetMap().get(menuId));
    }

    @Test
    public void testAddGroupMenuItem() {
        String menuId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        this.workbenchMenuCompactNavBarView.addGroupMenuItem(menuId, label, position);
        ((DropDownMenu)Mockito.verify((Object)this.dropDownMenu)).add((Widget)this.dropDownHeader);
        ((DropDownHeader)Mockito.verify((Object)this.dropDownHeader)).setText(label);
    }

    @Test
    public void testAddContextMenuItem() {
        String menuItemId = "menuItemId";
        String menuId = RandomStringUtils.random((int)10);
        String menuParentId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        Command command = (Command)Mockito.mock(Command.class);
        this.workbenchMenuCompactNavBarView.addContextMenuItem("menuItemId", menuId, label, menuParentId, command, position);
        ((AnchorListItem)Mockito.verify((Object)this.anchorListItem)).setText(label);
        Assert.assertEquals((Object)this.anchorListItem, this.workbenchMenuCompactNavBarView.getMenuItemContextWidgetMap().get(menuId));
        Assert.assertTrue((boolean)this.workbenchMenuCompactNavBarView.getMenuItemContextMenus().containsValue((Object)this.anchorListItem));
    }

    @Test
    public void testAddContextGroupMenuItem() {
        String menuItemId = "menuItemId";
        String menuId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        this.workbenchMenuCompactNavBarView.addContextGroupMenuItem("menuItemId", menuId, label, position);
        ((AnchorButton)Mockito.verify((Object)this.anchorButton)).setText(label);
        ((ListDropDown)Mockito.verify((Object)this.listDropDown)).add((Widget)this.anchorButton);
        Assert.assertEquals((Object)this.dropDownMenu, this.workbenchMenuCompactNavBarView.getMenuItemContextWidgetMap().get(menuId));
        Assert.assertTrue((boolean)this.workbenchMenuCompactNavBarView.getMenuItemContextMenus().containsValue((Object)this.listDropDown));
    }

    @Test
    public void testSelectElement() {
        ComplexPanel panel = (ComplexPanel)Mockito.mock(ComplexPanel.class);
        ComplexPanel panelActive = (ComplexPanel)Mockito.mock(ComplexPanel.class);
        Mockito.when((Object)this.dropDownMenu.iterator()).thenReturn(Collections.singletonList(panel).iterator());
        this.workbenchMenuCompactNavBarView.selectElement(panelActive);
        ((ComplexPanel)Mockito.verify((Object)panelActive)).addStyleName("active");
        ((ComplexPanel)Mockito.verify((Object)panel)).removeStyleName("active");
    }

    @Test
    public void testSelectMenuItemNoMenu() {
        String menuId = "menuId";
        this.workbenchMenuCompactNavBarView.addContextMenuItem("menuId", "contextMenuId", "labelContext", null, null, null);
        this.workbenchMenuCompactNavBarView.selectMenuItem("menuId");
        ((NavbarNav)Mockito.verify((Object)this.navbarNav)).add((Widget)this.anchorListItem);
        ((Text)Mockito.verify((Object)this.text)).setText("");
    }

    @Test
    public void testSelectMenuItem() {
        String menuId = "menuId";
        String label = "label";
        String labelContext = "labelContext";
        Mockito.when((Object)this.dropDownMenu.iterator()).thenReturn(Collections.emptyList().iterator());
        this.workbenchMenuCompactNavBarView.addContextMenuItem("menuId", "contextMenuId", "labelContext", null, null, null);
        this.workbenchMenuCompactNavBarView.addMenuItem("menuId", "label", null, null, null);
        this.workbenchMenuCompactNavBarView.selectMenuItem("menuId");
        ((NavbarNav)Mockito.verify((Object)this.navbarNav)).add((Widget)this.anchorListItem);
        ((Text)Mockito.verify((Object)this.text)).setText("label");
        ((AnchorListItem)Mockito.verify((Object)this.anchorListItem)).setText("labelContext");
        ((AnchorListItem)Mockito.verify((Object)this.anchorListItem)).setText("label");
        ((DropDownMenu)Mockito.verify((Object)this.dropDownMenu)).add((Widget)this.anchorListItem);
    }

    @Test
    public void testClearContextMenu() {
        String menuId = "menuId";
        this.workbenchMenuCompactNavBarView.addContextMenuItem("menuId", "contextMenuItemId", "labelContextMenu", null, null, null);
        this.workbenchMenuCompactNavBarView.addContextGroupMenuItem("menuId", "contextGroupMenuId", "labelContextGroup", null);
        this.workbenchMenuCompactNavBarView.clearContextMenu();
        Assert.assertTrue((boolean)this.workbenchMenuCompactNavBarView.getMenuItemContextMenus().isEmpty());
        Assert.assertTrue((boolean)this.workbenchMenuCompactNavBarView.getMenuItemContextWidgetMap().isEmpty());
        ((AnchorListItem)Mockito.verify((Object)this.anchorListItem, (VerificationMode)Mockito.times((int)2))).clear();
        ((AnchorListItem)Mockito.verify((Object)this.anchorListItem, (VerificationMode)Mockito.times((int)2))).removeFromParent();
        ((ListDropDown)Mockito.verify((Object)this.listDropDown)).clear();
        ((ListDropDown)Mockito.verify((Object)this.listDropDown)).removeFromParent();
    }

    @Test
    public void testClear() {
        this.workbenchMenuCompactNavBarView.getMenuItemContextMenus().put((Object)"key", (Object)((ComplexPanel)Mockito.mock(ComplexPanel.class)));
        this.workbenchMenuCompactNavBarView.getMenuItemContextWidgetMap().put("key", (ComplexPanel)Mockito.mock(ComplexPanel.class));
        this.workbenchMenuCompactNavBarView.clear();
        ((NavbarNav)Mockito.verify((Object)this.navbarNav)).clear();
        Assert.assertTrue((boolean)this.workbenchMenuCompactNavBarView.getMenuItemContextMenus().isEmpty());
        Assert.assertTrue((boolean)this.workbenchMenuCompactNavBarView.getMenuItemContextWidgetMap().isEmpty());
    }
}

