/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Option;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.client.views.pfly.widgets.Select;

@RunWith(value=MockitoJUnitRunner.class)
public class SelectTest {
    @Mock
    Document document;
    @Mock
    org.jboss.errai.common.client.dom.Select selectMock;
    @InjectMocks
    Select select;

    @Test
    public void testAddOption() {
        Option option = (Option)Mockito.mock(Option.class);
        Mockito.when((Object)this.document.createElement("option")).thenReturn((Object)option);
        this.select.addOption("text", "subText", "value", Boolean.valueOf(true));
        ((Option)Mockito.verify((Object)option)).setText("text");
        ((Option)Mockito.verify((Object)option)).setValue("value");
        ((Option)Mockito.verify((Object)option)).setSelected(true);
        option.setAttribute("data-subtext", "subText");
        ((org.jboss.errai.common.client.dom.Select)Mockito.verify((Object)this.selectMock)).add((HTMLElement)option);
    }

    @Test
    public void testTitle() {
        String title = "title";
        this.select.setTitle("title");
        ((org.jboss.errai.common.client.dom.Select)Mockito.verify((Object)this.selectMock)).setTitle("title");
    }

    @Test
    public void testLiveSearch() {
        this.select.setLiveSearch(Boolean.valueOf(true));
        ((org.jboss.errai.common.client.dom.Select)Mockito.verify((Object)this.selectMock)).setAttribute("data-live-search", "true");
    }

    @Test
    public void testWidth() {
        this.select.setWidth("auto");
        ((org.jboss.errai.common.client.dom.Select)Mockito.verify((Object)this.selectMock)).setAttribute("data-width", "auto");
    }

    @Test
    public void testValue() {
        String value = "somevalue";
        Mockito.when((Object)this.selectMock.getValue()).thenReturn((Object)"somevalue");
        Assert.assertEquals((Object)"somevalue", (Object)this.select.getValue());
    }
}

