/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.KeyboardEvent;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.SanitizedNumberInput;

@RunWith(value=MockitoJUnitRunner.class)
public class SanitizedNumberInputTest {
    @InjectMocks
    SanitizedNumberInput input;
    private boolean allowNegative = false;
    private boolean allowDecimal = false;

    @Before
    public void setup() {
    }

    @Test
    public void testNumericInput() {
        this.testValidKeyCode("9");
        this.testValidKeyCode("8");
        this.testValidKeyCode("0");
        this.testValidKeyCode("Backspace");
        this.testInvalidKeyCode("-");
        this.testInvalidKeyCode("+");
        this.testInvalidKeyCode(" ");
        this.testInvalidKeyCode(".");
    }

    @Test
    public void testNumericInputNegative() {
        this.allowNegative = true;
        this.allowDecimal = false;
        this.testValidKeyCode("-");
        this.testInvalidKeyCode(".");
    }

    @Test
    public void testNumericInputDecimal() {
        this.allowNegative = false;
        this.allowDecimal = true;
        this.testInvalidKeyCode("-");
        this.testValidKeyCode(".");
    }

    @Test
    public void testNumericInputNegativeDecimal() {
        this.allowNegative = true;
        this.allowDecimal = true;
        this.testValidKeyCode("-");
        this.testValidKeyCode(".");
    }

    protected void testValidKeyCode(String key) {
        this.testKeyCode(key, 0);
    }

    protected void testInvalidKeyCode(String key) {
        this.testKeyCode(key, 1);
    }

    protected void testKeyCode(String key, int wantedNumberOfInvocations) {
        KeyboardEvent event = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        Mockito.when((Object)event.getKey()).thenReturn((Object)key);
        this.input.getEventListener(this.allowNegative, this.allowDecimal).call((Event)event);
        ((KeyboardEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.times((int)wantedNumberOfInvocations))).preventDefault();
    }
}

