/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.tab;

import com.google.common.collect.Multimap;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashSet;
import java.util.Set;
import org.gwtbootstrap3.client.shared.event.TabShowHandler;
import org.gwtbootstrap3.client.shared.event.TabShownHandler;
import org.gwtbootstrap3.client.ui.NavTabs;
import org.gwtbootstrap3.client.ui.TabContent;
import org.gwtbootstrap3.client.ui.TabPane;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.views.pfly.tab.TabPanelEntry;
import org.uberfire.client.views.pfly.tab.TabPanelWithDropdowns;

@RunWith(value=GwtMockitoTestRunner.class)
public class TabPanelWithDropdownsTest {
    @Mock
    private TabPanelEntry tab;
    @Mock
    private Multimap<TabPanelEntry, HandlerRegistration> registrations;
    @Mock
    private TabPanelEntry.DropDownTabListItem tabWidget;
    @Mock
    private TabShowHandler tabShowHandler;
    @Mock
    private TabShownHandler tabShownHandler;
    @Mock
    private HandlerRegistration showHandlerRegistration;
    @Mock
    private HandlerRegistration shownHandlerRegistration;
    @Mock
    private TabPanelEntry tabPanelEntry;
    @Mock
    private HorizontalPanel tabBarWidgetsPanel;
    private Set<TabPanelEntry> tabPanelEntries;
    private TabPanelWithDropdowns tabPanel;

    @Before
    public void setUp() {
        this.tabPanel = (TabPanelWithDropdowns)Mockito.spy((Object)new TabPanelWithDropdowns());
        this.tabPanelEntries = new HashSet<TabPanelEntry>(){
            {
                this.add(TabPanelWithDropdownsTest.this.tabPanelEntry);
            }
        };
    }

    @Test
    public void testAddItem() {
        boolean index = true;
        ((TabPanelWithDropdowns)Mockito.doNothing().when((Object)this.tabPanel)).insertItem((TabPanelEntry)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((TabPanelWithDropdowns)Mockito.doReturn(this.tabPanelEntries).when((Object)this.tabPanel)).getAllContentTabs();
        this.tabPanel.addItem(this.tab);
        ((TabPanelWithDropdowns)Mockito.verify((Object)this.tabPanel)).insertItem(this.tab, 1);
    }

    @Test
    public void testInsertItem() {
        boolean index = true;
        ((TabPanelWithDropdowns)Mockito.doNothing().when((Object)this.tabPanel)).registerTabHandlers((TabPanelEntry)ArgumentMatchers.any());
        ((TabPanelWithDropdowns)Mockito.doNothing().when((Object)this.tabPanel)).insertTabAndContent((TabPanelEntry)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((TabPanelWithDropdowns)Mockito.doNothing().when((Object)this.tabPanel)).resizeTabContent();
        this.tabPanel.insertItem(this.tabPanelEntry, 1);
        ((TabPanelWithDropdowns)Mockito.verify((Object)this.tabPanel)).registerTabHandlers(this.tabPanelEntry);
        ((TabPanelWithDropdowns)Mockito.verify((Object)this.tabPanel)).insertTabAndContent(this.tabPanelEntry, 1);
        ((TabPanelWithDropdowns)Mockito.verify((Object)this.tabPanel)).resizeTabContent();
    }

    @Test
    public void testInsertTabAndContent() {
        boolean index = true;
        TabPane tabContentPane = (TabPane)Mockito.mock(TabPane.class);
        NavTabs tabBar = (NavTabs)Mockito.mock(NavTabs.class);
        TabContent tabContent = (TabContent)Mockito.mock(TabContent.class);
        Set allContentTabs = (Set)Mockito.spy(new HashSet());
        Set activatableWidgets = (Set)Mockito.spy(new HashSet());
        ((TabPanelEntry)Mockito.doReturn((Object)this.tabWidget).when((Object)this.tab)).getTabWidget();
        ((TabPanelEntry)Mockito.doReturn((Object)tabContentPane).when((Object)this.tab)).getContentPane();
        ((TabPanelWithDropdowns)Mockito.doReturn((Object)tabBar).when((Object)this.tabPanel)).getTabBar();
        ((TabPanelWithDropdowns)Mockito.doReturn((Object)tabContent).when((Object)this.tabPanel)).getTabContent();
        ((TabPanelWithDropdowns)Mockito.doReturn((Object)allContentTabs).when((Object)this.tabPanel)).getAllContentTabs();
        ((TabPanelWithDropdowns)Mockito.doReturn((Object)activatableWidgets).when((Object)this.tabPanel)).getActivatableWidgets();
        this.tabPanel.insertTabAndContent(this.tab, 1);
        ((NavTabs)Mockito.verify((Object)tabBar)).insert((Widget)this.tab.getTabWidget(), 1);
        ((Set)Mockito.verify((Object)allContentTabs)).add(this.tab);
        ((TabContent)Mockito.verify((Object)tabContent)).add((Widget)tabContentPane);
        ((Set)Mockito.verify((Object)activatableWidgets)).add(this.tabWidget);
    }

    @Test
    public void testRegisterTabHandlers() {
        ((TabPanelWithDropdowns)Mockito.doReturn(this.registrations).when((Object)this.tabPanel)).getTabHandlerRegistrations();
        ((TabPanelEntry)Mockito.doReturn((Object)this.tabWidget).when((Object)this.tab)).getTabWidget();
        ((TabPanelWithDropdowns)Mockito.doReturn((Object)this.tabShowHandler).when((Object)this.tabPanel)).getIndividualTabShowHandler();
        ((TabPanelWithDropdowns)Mockito.doReturn((Object)this.tabShownHandler).when((Object)this.tabPanel)).getIndividualTabShownHandler();
        ((TabPanelEntry.DropDownTabListItem)Mockito.doReturn((Object)this.showHandlerRegistration).when((Object)this.tabWidget)).addShowHandler(this.tabShowHandler);
        ((TabPanelEntry.DropDownTabListItem)Mockito.doReturn((Object)this.shownHandlerRegistration).when((Object)this.tabWidget)).addShownHandler(this.tabShownHandler);
        this.tabPanel.registerTabHandlers(this.tab);
        ((Multimap)Mockito.verify(this.registrations)).put((Object)this.tab, (Object)this.shownHandlerRegistration);
        ((Multimap)Mockito.verify(this.registrations)).put((Object)this.tab, (Object)this.showHandlerRegistration);
    }

    @Test
    public void testAddTabBarWidget() throws Exception {
        ((TabPanelWithDropdowns)Mockito.doReturn((Object)this.tabBarWidgetsPanel).when((Object)this.tabPanel)).getWidgetsPanel();
        IsWidget widget = (IsWidget)Mockito.mock(IsWidget.class);
        this.tabPanel.addTabBarWidget(widget);
        ((HorizontalPanel)Mockito.verify((Object)this.tabBarWidgetsPanel)).add((IsWidget)Mockito.eq((Object)widget));
        ((HorizontalPanel)Mockito.verify((Object)this.tabBarWidgetsPanel)).setCellHorizontalAlignment((IsWidget)Mockito.eq((Object)widget), (HasHorizontalAlignment.HorizontalAlignmentConstant)Mockito.eq((Object)HasHorizontalAlignment.HorizontalAlignmentConstant.endOf((HasDirection.Direction)HasDirection.Direction.LTR)));
    }
}

