/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.monaco;

import com.google.gwt.core.client.JsArrayString;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.views.pfly.monaco.MonacoEditorInitializer;
import org.uberfire.client.views.pfly.monaco.jsinterop.Monaco;
import org.uberfire.client.views.pfly.monaco.jsinterop.MonacoLoader;

@RunWith(value=GwtMockitoTestRunner.class)
public class MonacoEditorInitializerTest {
    @Mock
    private JsArrayString monacoModule;
    @Mock
    private Monaco monaco;
    @Captor
    private ArgumentCaptor<MonacoLoader.CallbackFunction> callbackFunctionCaptor;
    private MonacoEditorInitializer initializer;

    @Before
    public void setup() {
        this.initializer = (MonacoEditorInitializer)Mockito.spy((Object)new MonacoEditorInitializer());
    }

    @Test
    public void testRequire() {
        int[] monacoConsumerCalls = new int[1];
        Consumer<Monaco> monacoConsumer = e -> {
            monacoConsumerCalls[0] = monacoConsumerCalls[0] + 1;
        };
        ((MonacoEditorInitializer)Mockito.doNothing().when((Object)this.initializer)).require((JsArrayString)Matchers.any(), (MonacoLoader.CallbackFunction)Matchers.any());
        ((MonacoEditorInitializer)Mockito.doReturn((Object)this.monacoModule).when((Object)this.initializer)).monacoModule();
        this.initializer.require(monacoConsumer);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.initializer});
        ((MonacoEditorInitializer)inOrder.verify((Object)this.initializer)).switchAMDLoaderFromDefaultToMonaco();
        ((MonacoEditorInitializer)inOrder.verify((Object)this.initializer)).require((JsArrayString)Matchers.eq((Object)this.monacoModule), (MonacoLoader.CallbackFunction)this.callbackFunctionCaptor.capture());
        ((MonacoLoader.CallbackFunction)this.callbackFunctionCaptor.getValue()).call(this.monaco);
        Assert.assertEquals((long)1L, (long)monacoConsumerCalls[0]);
        ((MonacoEditorInitializer)inOrder.verify((Object)this.initializer)).switchAMDLoaderFromMonacoToDefault();
    }

    @Test
    public void testMonacoModule() {
        JsArrayString expectedModules = (JsArrayString)Mockito.mock(JsArrayString.class);
        ((MonacoEditorInitializer)Mockito.doReturn((Object)expectedModules).when((Object)this.initializer)).makeJsArrayString();
        JsArrayString actualModules = this.initializer.monacoModule();
        ((JsArrayString)Mockito.verify((Object)expectedModules)).push("vs/editor/editor.main");
        Assert.assertEquals((Object)expectedModules, (Object)actualModules);
    }
}

