/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.multipage;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.shared.event.TabShowEvent;
import org.gwtbootstrap3.client.shared.event.TabShowHandler;
import org.gwtbootstrap3.client.shared.event.TabShownEvent;
import org.gwtbootstrap3.client.shared.event.TabShownHandler;
import org.uberfire.client.views.pfly.multipage.PageViewImpl;
import org.uberfire.client.views.pfly.tab.ResizeTabPanel;
import org.uberfire.client.views.pfly.tab.TabPanelEntry;
import org.uberfire.client.workbench.widgets.multipage.MultiPageEditorView;
import org.uberfire.client.workbench.widgets.multipage.Multiple;
import org.uberfire.client.workbench.widgets.multipage.Page;

@Dependent
@Multiple
public class MultiPageEditorViewImpl
extends ResizeTabPanel
implements MultiPageEditorView {
    @Override
    public void init() {
        super.init();
        this.addShowHandler(new TabShowHandler(){

            public void onShow(TabShowEvent e) {
                MultiPageEditorViewImpl.this.onResize();
                TabPanelEntry tabPanelEntry = MultiPageEditorViewImpl.this.findEntryForTabWidget(e.getTab());
                PageViewImpl page = (PageViewImpl)tabPanelEntry.getContentPane().getWidget(0);
                page.onFocus();
            }
        });
        this.addShownHandler(new TabShownHandler(){

            public void onShown(TabShownEvent e) {
                MultiPageEditorViewImpl.this.onResize();
                TabPanelEntry tabPanelEntry = MultiPageEditorViewImpl.this.findEntryForTabWidget(e.getTab());
                PageViewImpl page = (PageViewImpl)tabPanelEntry.getContentPane().getWidget(0);
                page.onLostFocus();
            }
        });
        this.tabBar.addStyleName("nav-tabs-pf");
        this.addStyleName("uf-multi-page-editor");
    }

    public void addPage(Page page) {
        TabPanelEntry tab = this.makeTabPanelEntry(page);
        this.addItem(tab);
        this.setAsActive(tab);
    }

    public void addPage(int index, Page page) {
        TabPanelEntry tab = this.makeTabPanelEntry(page);
        this.insertItem(tab, index);
        this.setAsActive(tab);
    }

    TabPanelEntry makeTabPanelEntry(Page page) {
        String title = page.getLabel();
        Widget contents = page.getView().asWidget();
        return new TabPanelEntry(title, contents);
    }

    void setAsActive(TabPanelEntry tab) {
        if (this.getActiveTab() == null) {
            tab.showTab();
            tab.setActive(true);
        }
    }

    public void selectPage(int index) {
        this.selectTabIndex(index);
    }

    public int selectedPage() {
        return this.getSelectedTabIndex();
    }

    public void disablePage(int index) {
        if (!this.isValid(index)) {
            return;
        }
        Widget tab = this.getTabBar().getWidget(index);
        tab.addStyleName("disabled");
        this.disableWidget(tab);
    }

    public void enablePage(int index) {
        if (!this.isValid(index)) {
            return;
        }
        Widget tab = this.getTabBar().getWidget(index);
        tab.removeStyleName("disabled");
        this.enableWidget(tab);
    }

    boolean isValid(int index) {
        return this.getTabBar().getWidgetCount() > index;
    }

    private void enableWidget(Widget tab) {
        this.style(tab).clearProperty("pointerEvents");
    }

    private void disableWidget(Widget tab) {
        this.style(tab).setProperty("pointerEvents", "none");
    }

    private Style style(Widget tab) {
        return tab.getElement().getStyle();
    }
}

