/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.tab;

import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.GwtBootstrap3EntryPoint;
import org.gwtbootstrap3.client.shared.event.TabShowHandler;
import org.gwtbootstrap3.client.shared.event.TabShownHandler;
import org.jboss.errai.enterprise.client.cdi.AbstractErraiCDITest;
import org.uberfire.client.views.pfly.mock.CountingTabShowHandler;
import org.uberfire.client.views.pfly.mock.CountingTabShownHandler;
import org.uberfire.client.views.pfly.tab.TabPanelEntry;
import org.uberfire.client.views.pfly.tab.TabPanelWithDropdowns;

public class TabPanelWithDropdownsCDITest
extends AbstractErraiCDITest {
    private TabPanelWithDropdowns tabPanel;

    public String getModuleName() {
        return "org.uberfire.client.views.pfly.PatternFlyTabTests";
    }

    protected void gwtSetUp() throws Exception {
        super.gwtSetUp();
        this.tabPanel = new TabPanelWithDropdowns();
        this.tabPanel.init();
        new GwtBootstrap3EntryPoint().onModuleLoad();
    }

    public void testAddTabByTitleAndContent() throws Exception {
        Label content = new Label("First tab's content");
        TabPanelEntry item = this.tabPanel.addItem("First Tab", (Widget)content);
        TabPanelWithDropdownsCDITest.assertNotNull((Object)item.getTabWidget());
        TabPanelWithDropdownsCDITest.assertNotNull((Object)item.getContents());
        TabPanelWithDropdownsCDITest.assertEquals((String)item.getTitle(), (String)"First Tab");
        TabPanelWithDropdownsCDITest.assertNotNull((Object)content.getParent());
    }

    public void testShowTab() throws Exception {
        RootPanel.get().add((Widget)this.tabPanel);
        TabPanelEntry item1 = this.tabPanel.addItem("First Tab", (Widget)new Label("First tab's content"));
        TabPanelEntry item2 = this.tabPanel.addItem("Second Tab", (Widget)new Label("Second tab's content"));
        item2.showTab();
        item1.showTab();
        TabPanelWithDropdownsCDITest.assertTrue((boolean)item1.getContentPane().isActive());
        TabPanelWithDropdownsCDITest.assertTrue((boolean)item1.getTabWidget().isActive());
        TabPanelWithDropdownsCDITest.assertEquals((Object)item1, (Object)this.tabPanel.getActiveTab());
        TabPanelWithDropdownsCDITest.assertFalse((boolean)item2.getContentPane().isActive());
        TabPanelWithDropdownsCDITest.assertFalse((boolean)item2.getTabWidget().isActive());
    }

    public void testRemoveActiveTab() throws Exception {
        RootPanel.get().add((Widget)this.tabPanel);
        TabPanelEntry item1 = this.tabPanel.addItem("First Tab", (Widget)new Label("First tab's content"));
        TabPanelEntry item2 = this.tabPanel.addItem("Second Tab", (Widget)new Label("Second tab's content"));
        item2.showTab();
        item1.showTab();
        this.tabPanel.remove(item1);
        TabPanelWithDropdownsCDITest.assertTrue((boolean)item1.getTabWidget().isActive());
        TabPanelWithDropdownsCDITest.assertNull((Object)this.tabPanel.getActiveTab());
        TabPanelWithDropdownsCDITest.assertEquals((Object)item1.getContentPane(), (Object)item1.getContents().getParent());
        TabPanelWithDropdownsCDITest.assertNull((Object)item1.getContentPane().getParent());
        TabPanelWithDropdownsCDITest.assertFalse((boolean)item2.getContentPane().isActive());
        TabPanelWithDropdownsCDITest.assertFalse((boolean)item2.getTabWidget().isActive());
    }

    public void testRebroadcastShowEvents() throws Exception {
        RootPanel.get().add((Widget)this.tabPanel);
        CountingTabShowHandler showHandler = new CountingTabShowHandler();
        CountingTabShownHandler shownHandler = new CountingTabShownHandler();
        this.tabPanel.addShowHandler((TabShowHandler)showHandler);
        this.tabPanel.addShownHandler((TabShownHandler)shownHandler);
        TabPanelEntry item1 = this.tabPanel.addItem("First Tab", (Widget)new Label("First tab's content"));
        TabPanelWithDropdownsCDITest.assertNull((Object)this.tabPanel.getActiveTab());
        item1.showTab();
        TabPanelWithDropdownsCDITest.assertNotNull((Object)this.tabPanel.getActiveTab());
        TabPanelWithDropdownsCDITest.assertEquals((int)1, (int)showHandler.getEventCount());
        TabPanelWithDropdownsCDITest.assertEquals((int)1, (int)shownHandler.getEventCount());
    }
}

