/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.listbar;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.LinkedHashSet;
import java.util.List;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.PanelBody;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.listbar.ListBarWidgetImpl;
import org.uberfire.client.views.pfly.listbar.PartListDropdown;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.commons.data.Pair;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.Permission;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class ListBarWidgetImplTest {
    @Mock
    AuthorizationManager authzManager;
    @Mock
    User identity;
    @Mock
    PanelManager panelManager;
    @Spy
    @InjectMocks
    ListBarWidgetImpl listBar;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.authzManager.authorize((Permission)Matchers.any(Permission.class), (User)Matchers.any(User.class))).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.any(User.class))).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (ResourceAction)Matchers.any(ResourceAction.class), (User)Matchers.any(User.class))).thenReturn((Object)true);
        ((ListBarWidgetImpl)Mockito.doNothing().when((Object)this.listBar)).setupContextMenu();
        this.listBar.contextMenu = (ButtonGroup)Mockito.mock(ButtonGroup.class);
        this.listBar.titleDropDown = (PartListDropdown)Mockito.mock(PartListDropdown.class);
        this.listBar.content = (PanelBody)Mockito.mock(PanelBody.class);
        this.listBar.header = (PanelHeader)Mockito.mock(PanelHeader.class);
        Element element = (Element)Mockito.mock(Element.class);
        Style style = (Style)Mockito.mock(Style.class);
        ((Element)Mockito.doReturn((Object)style).when((Object)element)).getStyle();
        ((PanelBody)Mockito.doReturn((Object)element).when((Object)this.listBar.content)).getElement();
    }

    @Test
    public void onSelectPartOnPartHiddenEventIsFiredTest() {
        PartDefinition selectedPart = (PartDefinition)Mockito.mock(PartDefinition.class);
        PartDefinition currentPart = (PartDefinition)Mockito.mock(PartDefinition.class);
        this.listBar.partContentView.put(selectedPart, new FlowPanel());
        this.listBar.parts.add(selectedPart);
        this.listBar.currentPart = Pair.newPair((Object)currentPart, (Object)new FlowPanel());
        this.listBar.partContentView.put(currentPart, new FlowPanel());
        this.listBar.selectPart(selectedPart);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).onPartHidden(currentPart);
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar)).resizePanelBody();
    }

    @Test
    public void partsIsAddedToListBarTest() {
        PartDefinition firstPart = (PartDefinition)Mockito.mock(PartDefinition.class);
        PartDefinition secondPart = (PartDefinition)Mockito.mock(PartDefinition.class);
        this.listBar.parts.add(firstPart);
        this.listBar.parts.add(secondPart);
        Assert.assertEquals((long)2L, (long)this.listBar.getParts().size());
    }

    @Test
    public void changeTitleForSelectablePart() {
        PartDefinition part = this.getPartDefinition(true, false);
        IsWidget widget = (IsWidget)Mockito.mock(IsWidget.class);
        this.listBar.changeTitle(part, "title", widget);
        ((PartListDropdown)Mockito.verify((Object)this.listBar.titleDropDown)).changeTitle(part, "title", widget);
    }

    @Test
    public void changeTitleForUnselectablePart() {
        PartDefinition part = this.getPartDefinition(false, false);
        IsWidget widget = (IsWidget)Mockito.mock(IsWidget.class);
        this.listBar.changeTitle(part, "title", widget);
        ((PartListDropdown)Mockito.verify((Object)this.listBar.titleDropDown, (VerificationMode)Mockito.never())).changeTitle(part, "title", widget);
    }

    @Test
    public void addNewSelectablePartTest() {
        PartDefinition part = this.getPartDefinition(true, false);
        WorkbenchPartPresenter presenter = this.getWorkbenchPartPresenter(part);
        WorkbenchPartPresenter.View view = this.getWorkbenchPartView(presenter);
        this.listBar.addPart(view);
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar, (VerificationMode)Mockito.never())).selectPart(part);
        ((PartListDropdown)Mockito.verify((Object)this.listBar.titleDropDown)).addPart(view);
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar)).setupCSSLocators((WorkbenchPartPresenter.View)Matchers.any(), (FlowPanel)Matchers.any());
    }

    @Test
    public void addNewUnselectablePartTest() {
        PartDefinition part = this.getPartDefinition(false, false);
        WorkbenchPartPresenter presenter = this.getWorkbenchPartPresenter(part);
        WorkbenchPartPresenter.View view = this.getWorkbenchPartView(presenter);
        this.listBar.addPart(view);
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar, (VerificationMode)Mockito.never())).selectPart(part);
        ((PartListDropdown)Mockito.verify((Object)this.listBar.titleDropDown, (VerificationMode)Mockito.never())).addPart(view);
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar)).resizePanelBody();
    }

    @Test
    public void addExistentPartTest() {
        PartDefinition part = this.getPartDefinition(true, true);
        WorkbenchPartPresenter presenter = this.getWorkbenchPartPresenter(part);
        WorkbenchPartPresenter.View view = this.getWorkbenchPartView(presenter);
        this.listBar.addPart(view);
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar)).selectPart(part);
        ((PartListDropdown)Mockito.verify((Object)this.listBar.titleDropDown, (VerificationMode)Mockito.never())).addPart(view);
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar)).resizePanelBody();
    }

    @Test
    public void selectNewPartTest() {
        PartDefinition part = this.getPartDefinition(true, false);
        boolean selected = this.listBar.selectPart(part);
        Assert.assertFalse((boolean)selected);
        ((PartListDropdown)Mockito.verify((Object)this.listBar.titleDropDown, (VerificationMode)Mockito.never())).selectPart(part);
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar, (VerificationMode)Mockito.never())).setupContextMenu();
        ((PanelHeader)Mockito.verify((Object)this.listBar.header, (VerificationMode)Mockito.never())).setVisible(Mockito.anyBoolean());
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar, (VerificationMode)Mockito.never())).resizePanelBody();
    }

    @Test
    public void selectExistentUnselectablePartTest() {
        PartDefinition part = this.getPartDefinition(false, true);
        boolean selected = this.listBar.selectPart(part);
        Assert.assertTrue((boolean)selected);
        ((PartListDropdown)Mockito.verify((Object)this.listBar.titleDropDown, (VerificationMode)Mockito.never())).selectPart(part);
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar, (VerificationMode)Mockito.never())).setupContextMenu();
        ((PanelHeader)Mockito.verify((Object)this.listBar.header)).setVisible(false);
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar)).resizePanelBody();
    }

    @Test
    public void selectExistentSelectablePartTest() {
        PartDefinition part = this.getPartDefinition(true, true);
        boolean selected = this.listBar.selectPart(part);
        Assert.assertTrue((boolean)selected);
        ((PartListDropdown)Mockito.verify((Object)this.listBar.titleDropDown)).selectPart(part);
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar)).setupContextMenu();
        ((PanelHeader)Mockito.verify((Object)this.listBar.header)).setVisible(true);
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar)).resizePanelBody();
    }

    @Test
    public void removeUnselectablePartTest() {
        PartDefinition part = this.getPartDefinition(false, true);
        this.listBar.remove(part);
        ((PartListDropdown)Mockito.verify((Object)this.listBar.titleDropDown, (VerificationMode)Mockito.never())).removePart(part);
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar)).resizePanelBody();
    }

    @Test
    public void notifyPartHiddenOnRemoveTest() {
        PartDefinition part = this.getPartDefinition(true, true);
        this.listBar.selectPart(part);
        this.listBar.remove(part);
        ((PartListDropdown)Mockito.verify((Object)this.listBar.titleDropDown)).removePart(part);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).onPartHidden(part);
    }

    @Test
    public void removeSelectablePartTest() {
        PartDefinition part = this.getPartDefinition(true, true);
        this.listBar.remove(part);
        ((PartListDropdown)Mockito.verify((Object)this.listBar.titleDropDown)).removePart(part);
        ((ListBarWidgetImpl)Mockito.verify((Object)this.listBar)).resizePanelBody();
    }

    private PartDefinition getPartDefinition(boolean selectable, boolean existent) {
        PartDefinition part = (PartDefinition)Mockito.mock(PartDefinition.class);
        ((PartDefinition)Mockito.doReturn((Object)selectable).when((Object)part)).isSelectable();
        ((PartDefinition)Mockito.doReturn((Object)"").when((Object)part)).asString();
        if (existent) {
            this.listBar.partContentView.put(part, new FlowPanel());
            this.listBar.parts.add(part);
            this.listBar.partContentView.put(part, new FlowPanel());
        }
        return part;
    }

    private WorkbenchPartPresenter getWorkbenchPartPresenter(PartDefinition part) {
        WorkbenchPartPresenter presenter = (WorkbenchPartPresenter)Mockito.mock(WorkbenchPartPresenter.class);
        ((WorkbenchPartPresenter)Mockito.doReturn((Object)part).when((Object)presenter)).getDefinition();
        return presenter;
    }

    private WorkbenchPartPresenter.View getWorkbenchPartView(WorkbenchPartPresenter presenter) {
        WorkbenchPartPresenter.View view = (WorkbenchPartPresenter.View)Mockito.mock(WorkbenchPartPresenter.View.class);
        ((WorkbenchPartPresenter.View)Mockito.doReturn((Object)presenter).when((Object)view)).getPresenter();
        return view;
    }

    @Test
    public void testSingleMenu() {
        String caption = "test";
        Menus menus = ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)"test").respondsWith(() -> {})).endMenu()).build();
        Widget widget = this.listBar.makeItem((MenuItem)menus.getItems().get(0), true);
        Assert.assertTrue((boolean)(widget instanceof Button));
        ((Button)Mockito.verify((Object)((Button)widget))).setText("test");
    }

    @Test
    public void testSubMenus() {
        String caption = "test";
        String submenu1 = "submenu1";
        String submenu2 = "submenu2";
        Menus menus = ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.SubMenuBuilder)((MenuFactory.SubMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.SubMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)"test").menus().menu("submenu1").respondsWith(() -> {})).endMenu()).menu("submenu2").respondsWith(() -> {})).endMenu()).endMenus()).endMenu()).build();
        Widget widget = this.listBar.makeItem((MenuItem)menus.getItems().get(0), true);
        Assert.assertTrue((boolean)(widget instanceof ButtonGroup));
        ArgumentCaptor buttonCaptor = ArgumentCaptor.forClass(Widget.class);
        ((ButtonGroup)Mockito.verify((Object)((ButtonGroup)widget), (VerificationMode)Mockito.times((int)2))).add((Widget)buttonCaptor.capture());
        List widgetList = buttonCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)widgetList.size());
        ((Button)Mockito.verify((Object)((Button)widgetList.get(0)))).setText("test");
        ArgumentCaptor dropCaptor = ArgumentCaptor.forClass(Widget.class);
        ((DropDownMenu)Mockito.verify((Object)((DropDownMenu)widgetList.get(1)), (VerificationMode)Mockito.times((int)2))).add((Widget)dropCaptor.capture());
        List subMenusWidgetList = dropCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)subMenusWidgetList.size());
        ((AnchorListItem)Mockito.verify((Object)((AnchorListItem)subMenusWidgetList.get(0)))).setText("submenu1");
        ((AnchorListItem)Mockito.verify((Object)((AnchorListItem)subMenusWidgetList.get(1)))).setText("submenu2");
    }

    @Test
    public void getNextSelectablePartTest() {
        PartDefinitionImpl part1 = new PartDefinitionImpl((PlaceRequest)Mockito.mock(PlaceRequest.class));
        part1.setSelectable(false);
        PartDefinitionImpl part2 = new PartDefinitionImpl((PlaceRequest)Mockito.mock(PlaceRequest.class));
        part2.setSelectable(true);
        PartDefinitionImpl part3 = new PartDefinitionImpl((PlaceRequest)Mockito.mock(PlaceRequest.class));
        part3.setSelectable(false);
        PartDefinitionImpl part4 = new PartDefinitionImpl((PlaceRequest)Mockito.mock(PlaceRequest.class));
        part4.setSelectable(true);
        PartDefinitionImpl part5 = new PartDefinitionImpl((PlaceRequest)Mockito.mock(PlaceRequest.class));
        part5.setSelectable(false);
        LinkedHashSet<PartDefinitionImpl> parts = new LinkedHashSet<PartDefinitionImpl>();
        parts.add(part1);
        parts.add(part2);
        parts.add(part3);
        parts.add(part4);
        parts.add(part5);
        ((ListBarWidgetImpl)Mockito.doReturn(parts).when((Object)this.listBar)).getUnselectedParts();
        Assert.assertSame((Object)part2, (Object)this.listBar.getNextPart((PartDefinition)part1));
        Assert.assertSame((Object)part4, (Object)this.listBar.getNextPart((PartDefinition)part2));
        Assert.assertSame((Object)part2, (Object)this.listBar.getNextPart((PartDefinition)part3));
        Assert.assertSame((Object)part2, (Object)this.listBar.getNextPart((PartDefinition)part4));
        Assert.assertSame((Object)part2, (Object)this.listBar.getNextPart((PartDefinition)part5));
    }

    @Test
    public void getFirstUnselectablePartTest() {
        PartDefinitionImpl part1 = new PartDefinitionImpl((PlaceRequest)Mockito.mock(PlaceRequest.class));
        part1.setSelectable(false);
        PartDefinitionImpl part2 = new PartDefinitionImpl((PlaceRequest)Mockito.mock(PlaceRequest.class));
        part2.setSelectable(true);
        PartDefinitionImpl part3 = new PartDefinitionImpl((PlaceRequest)Mockito.mock(PlaceRequest.class));
        part3.setSelectable(false);
        LinkedHashSet<PartDefinitionImpl> parts = new LinkedHashSet<PartDefinitionImpl>();
        parts.add(part1);
        parts.add(part2);
        parts.add(part3);
        ((ListBarWidgetImpl)Mockito.doReturn(parts).when((Object)this.listBar)).getUnselectedParts();
        Assert.assertSame((Object)part2, (Object)this.listBar.getNextPart((PartDefinition)part1));
        Assert.assertSame((Object)part1, (Object)this.listBar.getNextPart((PartDefinition)part2));
        Assert.assertSame((Object)part2, (Object)this.listBar.getNextPart((PartDefinition)part3));
    }

    @Test
    public void resizePanelBodyForUnselectablePart() {
        PartDefinitionImpl partDefinition = new PartDefinitionImpl((PlaceRequest)Mockito.mock(PlaceRequest.class));
        partDefinition.setSelectable(false);
        this.listBar.currentPart = new Pair((Object)partDefinition, Mockito.mock(FlowPanel.class));
        this.listBar.resizePanelBody();
        ((Style)Mockito.verify((Object)this.listBar.content.getElement().getStyle())).setProperty("height", "100%");
    }

    @Test
    public void resizePanelBodyForSelectablePart() {
        PartDefinitionImpl partDefinition = new PartDefinitionImpl((PlaceRequest)Mockito.mock(PlaceRequest.class));
        partDefinition.setSelectable(true);
        this.listBar.currentPart = new Pair((Object)partDefinition, Mockito.mock(FlowPanel.class));
        ((PanelHeader)Mockito.doReturn((Object)10).when((Object)this.listBar.header)).getOffsetHeight();
        this.listBar.resizePanelBody();
        ((Style)Mockito.verify((Object)this.listBar.content.getElement().getStyle())).setProperty("height", "calc(100% - 10px)");
    }
}

