/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.apache.commons.lang3.RandomStringUtils;
import org.gwtbootstrap3.client.ui.Collapse;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.menu.UtilityMenuBarView;
import org.uberfire.client.views.pfly.menu.WorkbenchMenuBarView;
import org.uberfire.client.views.pfly.menu.WorkbenchMenuCompactNavBarView;
import org.uberfire.client.views.pfly.menu.WorkbenchMenuStandardNavBarView;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuPosition;

@RunWith(value=GwtMockitoTestRunner.class)
public class WorkbenchMenuBarViewTest {
    @Mock
    private WorkbenchMenuCompactNavBarView workbenchMenuCompactNavBarView;
    @Mock
    private WorkbenchMenuStandardNavBarView workbenchMenuStandardNavBarView;
    @Mock
    private UtilityMenuBarView utilityMenuBarView;
    @GwtMock
    private Collapse navBarCollapse;
    @InjectMocks
    private WorkbenchMenuBarView workbenchMenuBarView;

    @Test
    public void testAddMenuItem() {
        String menuId = RandomStringUtils.random((int)10);
        String menuParentId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.LEFT;
        Command command = new Command(){

            public void execute() {
            }
        };
        this.workbenchMenuBarView.addMenuItem(menuId, label, menuParentId, command, position);
        ((WorkbenchMenuCompactNavBarView)Mockito.verify((Object)this.workbenchMenuCompactNavBarView)).addMenuItem(menuId, label, menuParentId, command, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).addMenuItem(menuId, label, menuParentId, command, position);
    }

    @Test
    public void testAddCustomMenuItem() {
        Widget menu = (Widget)GWT.create(Widget.class);
        MenuPosition position = MenuPosition.LEFT;
        this.workbenchMenuBarView.addCustomMenuItem(menu, position);
        ((WorkbenchMenuCompactNavBarView)Mockito.verify((Object)this.workbenchMenuCompactNavBarView)).addCustomMenuItem(menu, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).addCustomMenuItem(menu, position);
    }

    @Test
    public void testAddGroupMenuItem() {
        String menuId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.LEFT;
        this.workbenchMenuBarView.addGroupMenuItem(menuId, label, position);
        ((WorkbenchMenuCompactNavBarView)Mockito.verify((Object)this.workbenchMenuCompactNavBarView)).addGroupMenuItem(menuId, label, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).addGroupMenuItem(menuId, label, position);
    }

    @Test
    public void testAddContextMenuItem() {
        String menuItemId = RandomStringUtils.random((int)10);
        String menuId = RandomStringUtils.random((int)10);
        String menuParentId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        Command command = new Command(){

            public void execute() {
            }
        };
        this.workbenchMenuBarView.addContextMenuItem(menuItemId, menuId, label, menuParentId, command, position);
        ((WorkbenchMenuCompactNavBarView)Mockito.verify((Object)this.workbenchMenuCompactNavBarView)).addContextMenuItem(menuItemId, menuId, label, menuParentId, command, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).addContextMenuItem(menuItemId, menuId, label, menuParentId, command, position);
    }

    @Test
    public void testAddContextGroupMenuItem() {
        String menuItemId = RandomStringUtils.random((int)10);
        String menuId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.LEFT;
        this.workbenchMenuBarView.addContextGroupMenuItem(menuItemId, menuId, label, position);
        ((WorkbenchMenuCompactNavBarView)Mockito.verify((Object)this.workbenchMenuCompactNavBarView)).addContextGroupMenuItem(menuItemId, menuId, label, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).addContextGroupMenuItem(menuItemId, menuId, label, position);
    }

    @Test
    public void testSelectMenu() {
        String menuId = RandomStringUtils.random((int)10);
        this.workbenchMenuBarView.selectMenuItem(menuId);
        ((WorkbenchMenuCompactNavBarView)Mockito.verify((Object)this.workbenchMenuCompactNavBarView)).selectMenuItem(menuId);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).selectMenuItem(menuId);
    }

    @Test
    public void testClear() {
        this.workbenchMenuBarView.clear();
        ((WorkbenchMenuCompactNavBarView)Mockito.verify((Object)this.workbenchMenuCompactNavBarView)).clear();
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).clear();
        ((UtilityMenuBarView)Mockito.verify((Object)this.utilityMenuBarView)).clear();
    }

    @Test
    public void testEnableMenu() {
        String menuId = RandomStringUtils.random((int)10);
        this.workbenchMenuBarView.enableMenuItem(menuId, true);
        ((WorkbenchMenuCompactNavBarView)Mockito.verify((Object)this.workbenchMenuCompactNavBarView)).enableMenuItem(menuId, true);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).enableMenuItem(menuId, true);
    }

    @Test
    public void testDisableMenu() {
        String menuId = RandomStringUtils.random((int)10);
        this.workbenchMenuBarView.enableMenuItem(menuId, false);
        ((WorkbenchMenuCompactNavBarView)Mockito.verify((Object)this.workbenchMenuCompactNavBarView)).enableMenuItem(menuId, false);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).enableMenuItem(menuId, false);
    }

    @Test
    public void testEnableContextMenu() {
        String menuId = RandomStringUtils.random((int)10);
        this.workbenchMenuBarView.enableContextMenuItem(menuId, true);
        ((WorkbenchMenuCompactNavBarView)Mockito.verify((Object)this.workbenchMenuCompactNavBarView)).enableContextMenuItem(menuId, true);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).enableContextMenuItem(menuId, true);
    }

    @Test
    public void testDisableContextMenu() {
        String menuId = RandomStringUtils.random((int)10);
        this.workbenchMenuBarView.enableContextMenuItem(menuId, false);
        ((WorkbenchMenuCompactNavBarView)Mockito.verify((Object)this.workbenchMenuCompactNavBarView)).enableContextMenuItem(menuId, false);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).enableContextMenuItem(menuId, false);
    }

    @Test
    public void testClearContextMenu() {
        this.workbenchMenuBarView.clearContextMenu();
        ((WorkbenchMenuCompactNavBarView)Mockito.verify((Object)this.workbenchMenuCompactNavBarView)).clearContextMenu();
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).clearContextMenu();
    }

    @Test
    public void testExpand() {
        Mockito.when((Object)this.navBarCollapse.isHidden()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        this.workbenchMenuBarView.expand();
        this.workbenchMenuBarView.expand();
        ((Collapse)Mockito.verify((Object)this.navBarCollapse)).show();
        ((Collapse)Mockito.verify((Object)this.navBarCollapse, (VerificationMode)Mockito.never())).hide();
    }

    @Test
    public void testCollapse() {
        Mockito.when((Object)this.navBarCollapse.isShown()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        this.workbenchMenuBarView.collapse();
        this.workbenchMenuBarView.collapse();
        ((Collapse)Mockito.verify((Object)this.navBarCollapse)).hide();
        ((Collapse)Mockito.verify((Object)this.navBarCollapse, (VerificationMode)Mockito.never())).show();
    }
}

