/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.ListDropDown;
import org.gwtbootstrap3.client.ui.NavbarNav;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.menu.AuthFilterMenuVisitor;
import org.uberfire.client.views.pfly.menu.HasMenuItems;
import org.uberfire.client.views.pfly.menu.StackedDropdownMenuVisitor;
import org.uberfire.client.views.pfly.menu.WorkbenchMenuBarView;
import org.uberfire.client.workbench.widgets.menu.PerspectiveContextMenusPresenter;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemPerspective;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;

@ApplicationScoped
public class WorkbenchMenuStandardNavBarView
extends NavbarNav
implements WorkbenchMenuBarView.NavBarView,
HasMenuItems {
    private final Map<MenuItemPerspective, Widget> listItemMap = new HashMap<MenuItemPerspective, Widget>();
    @Inject
    private PerspectiveContextMenusPresenter.View perspectiveContextMenuView;
    @Inject
    private AuthorizationManager authzManager;
    @Inject
    private User identity;

    @PostConstruct
    protected void setup() {
        this.addStyleName("navbar-primary");
    }

    public void addMenus(Menus menus) {
        menus.accept((MenuVisitor)new AuthFilterMenuVisitor(this.authzManager, this.identity, (MenuVisitor)new StandardMenuVisitor(this)));
    }

    @Override
    public void addMenuItem(MenuPosition position, Widget menuContent) {
        if (position == null) {
            position = MenuPosition.CENTER;
        }
        switch (position) {
            case LEFT: {
                this.add(menuContent);
                break;
            }
            case CENTER: {
                this.insert(menuContent, this.getWidgetCount() - 1);
            }
            case RIGHT: {
                menuContent.addStyleName("pull-right");
                this.add(menuContent);
            }
        }
    }

    @Override
    public void selectMenu(MenuItem menu) {
        this.selectElement(this.listItemMap.get(menu));
    }

    private void selectElement(Widget item) {
        this.iterateWidgets((Widget)this);
        if (item != null) {
            item.addStyleName("active");
        }
        if (item.getParent().getParent() instanceof ListDropDown) {
            item.getParent().getParent().addStyleName("active");
        }
    }

    private void iterateWidgets(Widget widget) {
        widget.removeStyleName("active");
        if (widget instanceof ComplexPanel) {
            Iterator iterator = ((ComplexPanel)widget).iterator();
            while (iterator.hasNext()) {
                this.iterateWidgets((Widget)iterator.next());
            }
        }
    }

    private class StandardMenuVisitor
    extends StackedDropdownMenuVisitor {
        public StandardMenuVisitor(HasMenuItems hasMenuItems) {
            super(hasMenuItems);
        }

        @Override
        protected Widget buildMenuPerspective(MenuItemPerspective menuItemPerspective, HasMenuItems hasMenuItems) {
            Widget item = super.buildMenuPerspective(menuItemPerspective, hasMenuItems);
            WorkbenchMenuStandardNavBarView.this.listItemMap.put(menuItemPerspective, item);
            return item;
        }
    }
}

