/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.list;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;

@Dependent
@Alternative
public class EntitiesPagedList<T>
extends EntitiesList<T> {
    protected Collection<T> entities;
    protected EntitiesList.Callback<T> callback;
    protected int currentPage = -1;

    @Inject
    public EntitiesPagedList(LoadingBox loadingBox, EntitiesList.View view) {
        super(loadingBox, view);
    }

    @Override
    public void show(Collection<T> entities, EntitiesList.Callback<T> callback) {
        if (this.currentPage == -1) {
            this.currentPage = 1;
        }
        this.entities = entities;
        this.callback = callback;
        this.show();
    }

    protected void show() {
        if (this.callback != null && this.getEntities() != null) {
            int size = this.getEntities().size();
            this.totalPages = size / this.pageSize;
            int start = (this.currentPage - 1) * this.pageSize;
            boolean hasMorePages = this.hasMorePages();
            int end = hasMorePages ? start + this.pageSize : size;
            List<T> pageEntities = this.buildPageEntities(start, end);
            EntitiesList.PaginationConstraints paginationConstraints = this.buildPaginationConstraints(size);
            this.show(pageEntities, paginationConstraints, this.callback);
        }
    }

    @Override
    void onGoToFirstPage() {
        if (this.currentPage > -1) {
            this.currentPage = 1;
            this.show();
        } else {
            super.onGoToFirstPage();
        }
    }

    @Override
    void onGoToPrevPage() {
        if (this.currentPage > -1) {
            this.currentPage = this.paginationConstraints.getCurrentPage() - 1;
            this.show();
        } else {
            super.onGoToPrevPage();
        }
    }

    @Override
    void onGoToNextPage() {
        if (this.currentPage > -1) {
            this.currentPage = this.paginationConstraints.getCurrentPage() + 1;
            this.show();
        } else {
            super.onGoToNextPage();
        }
    }

    @Override
    void onGoToLastPage() {
        if (this.currentPage > -1) {
            this.currentPage = this.totalPages + 1;
            this.show();
        } else {
            super.onGoToLastPage();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.entities = null;
        this.callback = null;
        this.currentPage = -1;
    }

    protected Collection<T> getEntities() {
        return this.entities;
    }

    protected List<T> buildPageEntities(int start, int end) {
        return new LinkedList<T>(this.getEntities()).subList(start, end);
    }

    protected EntitiesList.PaginationConstraints buildPaginationConstraints(final int size) {
        final boolean hasMorePages = this.hasMorePages();
        final boolean isNotFirstPage = this.currentPage > 1;
        return new EntitiesList.PaginationConstraints(){

            @Override
            public boolean isFirstPageEnabled() {
                return isNotFirstPage;
            }

            @Override
            public boolean isFirstPageVisible() {
                return isNotFirstPage;
            }

            @Override
            public boolean isPrevPageEnabled() {
                return isNotFirstPage;
            }

            @Override
            public boolean isPrevPageVisible() {
                return isNotFirstPage;
            }

            @Override
            public int getCurrentPage() {
                return EntitiesPagedList.this.currentPage;
            }

            @Override
            public boolean isNextPageEnabled() {
                return hasMorePages;
            }

            @Override
            public boolean isNextPageVisible() {
                return hasMorePages;
            }

            @Override
            public boolean isLastPageEnabled() {
                return hasMorePages;
            }

            @Override
            public boolean isLastPageVisible() {
                return hasMorePages;
            }

            @Override
            public Integer getTotal() {
                return size;
            }
        };
    }

    protected boolean hasMorePages() {
        return this.currentPage < this.totalPages;
    }
}

