/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Badge;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.LinkedGroup;
import org.gwtbootstrap3.client.ui.LinkedGroupItem;
import org.gwtbootstrap3.client.ui.Pagination;
import org.gwtbootstrap3.client.ui.Row;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.HeadingSize;
import org.gwtbootstrap3.client.ui.constants.IconPosition;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;

@Dependent
public class EntitiesListView
extends Composite
implements EntitiesList.View {
    private static EntitiesListViewBinder uiBinder = (EntitiesListViewBinder)GWT.create(EntitiesListViewBinder.class);
    @UiField
    EntitiesListViewStyle style;
    @UiField
    Row emptyEntitiesRow;
    @UiField
    Label emptyEntitiesLabel;
    @UiField
    LinkedGroup entitiesList;
    @UiField
    Pagination pagination;
    @UiField
    AnchorListItem firstPageAnchor;
    @UiField
    AnchorListItem prevPageAnchor;
    @UiField
    AnchorListItem currentPageAnchor;
    @UiField
    AnchorListItem nextPageAnchor;
    @UiField
    AnchorListItem lastPageAnchor;
    @UiField
    Badge totalBadge;
    @UiField
    HTML totalText;
    private EntitiesList presenter;
    private HandlerRegistration firstPageAnchorClickHandlerRegistration = null;
    private HandlerRegistration prevPageAnchorClickHandlerRegistration = null;
    private HandlerRegistration nextPageAnchorClickHandlerRegistration = null;
    private HandlerRegistration lastPageAnchorClickHandlerRegistration = null;

    @PostConstruct
    protected void initUIBinder() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(EntitiesList presenter) {
        this.presenter = presenter;
    }

    @Override
    public EntitiesList.View configure(String emptyEntitiesText, EntitiesList.PaginationConstraints paginationConstraints) {
        this.clear();
        String emptyText = emptyEntitiesText != null ? emptyEntitiesText : UsersManagementWidgetsConstants.INSTANCE.emptyEntities();
        this.emptyEntitiesLabel.setText(emptyText);
        this.applyPaginationConstraints(paginationConstraints);
        return this;
    }

    @Override
    public EntitiesList.View add(int index, String identifier, String title, HeadingSize titleSize, boolean canRead, boolean canRemove, boolean canSelect, boolean isSelected) {
        this.addEntityInList(index, identifier, title, titleSize, canRead, canRemove, canSelect, isSelected);
        this.emptyEntitiesRow.setVisible(false);
        return this;
    }

    @Override
    public EntitiesList.View clear() {
        this.entitiesList.clear();
        this.emptyEntitiesRow.setVisible(true);
        return this;
    }

    private void addEntityInList(final int index, final String id, String title, HeadingSize titleSize, boolean canRead, boolean canRemove, boolean canSelect, boolean isSelected) {
        LinkedGroupItem groupItem = new LinkedGroupItem();
        groupItem.addStyleName(this.style.entityGroup());
        if (canRead) {
            groupItem.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    EntitiesListView.this.presenter.onReadEntity(id);
                }
            });
        }
        HorizontalPanel groupPanel = new HorizontalPanel();
        groupPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        groupPanel.addStyleName(this.style.entityPanel());
        if (canSelect) {
            final CheckBox checkBox = new CheckBox();
            checkBox.addStyleName(this.style.entityListButton());
            checkBox.addStyleName(this.style.left());
            checkBox.setValue(Boolean.valueOf(isSelected));
            checkBox.addDomHandler((EventHandler)new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    clickEvent.stopPropagation();
                    boolean value = checkBox.getValue();
                    EntitiesListView.this.presenter.onSelectEntity(id, index, checkBox.getValue());
                }
            }, ClickEvent.getType());
            groupPanel.add((Widget)checkBox);
        }
        Heading heading = new Heading(titleSize);
        heading.setText(title);
        heading.addStyleName(this.style.entityListTitle());
        groupPanel.add((Widget)heading);
        if (canRemove) {
            final Button removeButton = new Button();
            removeButton.addStyleName(this.style.entityListButton());
            removeButton.setSize(ButtonSize.EXTRA_SMALL);
            removeButton.setIconPosition(IconPosition.RIGHT);
            removeButton.setType(ButtonType.DEFAULT);
            removeButton.setText(UsersManagementWidgetsConstants.INSTANCE.remove());
            removeButton.setTitle(UsersManagementWidgetsConstants.INSTANCE.remove());
            removeButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    EntitiesListView.this.presenter.onRemoveEntity(id);
                }
            });
            removeButton.setVisible(false);
            groupPanel.add((Widget)removeButton);
            groupItem.addDomHandler((EventHandler)new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent mouseOverEvent) {
                    mouseOverEvent.stopPropagation();
                    removeButton.setVisible(true);
                }
            }, MouseOverEvent.getType());
            groupItem.addDomHandler((EventHandler)new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent mouseOverEvent) {
                    mouseOverEvent.stopPropagation();
                    removeButton.setVisible(false);
                }
            }, MouseOutEvent.getType());
        }
        groupItem.add((Widget)groupPanel);
        this.entitiesList.add((Widget)groupItem);
    }

    private void applyPaginationConstraints(EntitiesList.PaginationConstraints constraints) {
        boolean existsPagination;
        boolean bl = existsPagination = constraints != null;
        if (existsPagination) {
            final boolean isFirstPageEnabled = constraints.isFirstPageEnabled();
            boolean isFirstPageVisible = constraints.isFirstPageVisible();
            final boolean isPrevPageEnabled = constraints.isPrevPageEnabled();
            boolean isPrevPageVisible = constraints.isPrevPageVisible();
            int currentPage = constraints.getCurrentPage();
            final boolean isNextPageEnabled = constraints.isNextPageEnabled();
            boolean isNextPageVisible = constraints.isNextPageVisible();
            final boolean isLastPageEnabled = constraints.isLastPageEnabled();
            boolean isLastPageVisible = constraints.isLastPageVisible();
            Integer total = constraints.getTotal();
            boolean bl2 = existsPagination = isPrevPageVisible || isNextPageVisible;
            if (existsPagination) {
                this.firstPageAnchor.setEnabled(isFirstPageEnabled);
                this.firstPageAnchor.setVisible(isFirstPageVisible);
                if (this.firstPageAnchorClickHandlerRegistration != null) {
                    this.firstPageAnchorClickHandlerRegistration.removeHandler();
                }
                this.firstPageAnchorClickHandlerRegistration = this.firstPageAnchor.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent clickEvent) {
                        clickEvent.stopPropagation();
                        if (isFirstPageEnabled) {
                            EntitiesListView.this.presenter.onGoToFirstPage();
                        }
                    }
                });
                this.prevPageAnchor.setEnabled(isPrevPageEnabled);
                this.prevPageAnchor.setVisible(isPrevPageVisible);
                if (this.prevPageAnchorClickHandlerRegistration != null) {
                    this.prevPageAnchorClickHandlerRegistration.removeHandler();
                }
                this.prevPageAnchorClickHandlerRegistration = this.prevPageAnchor.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent clickEvent) {
                        clickEvent.stopPropagation();
                        if (isPrevPageEnabled) {
                            EntitiesListView.this.presenter.onGoToPrevPage();
                        }
                    }
                });
                this.currentPageAnchor.setText(Integer.toString(currentPage));
                this.nextPageAnchor.setEnabled(isNextPageEnabled);
                this.nextPageAnchor.setVisible(isNextPageVisible);
                if (this.nextPageAnchorClickHandlerRegistration != null) {
                    this.nextPageAnchorClickHandlerRegistration.removeHandler();
                }
                this.nextPageAnchorClickHandlerRegistration = this.nextPageAnchor.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent clickEvent) {
                        clickEvent.stopPropagation();
                        if (isNextPageEnabled) {
                            EntitiesListView.this.presenter.onGoToNextPage();
                        }
                    }
                });
                this.lastPageAnchor.setEnabled(isLastPageEnabled);
                this.lastPageAnchor.setVisible(isLastPageVisible);
                if (this.lastPageAnchorClickHandlerRegistration != null) {
                    this.lastPageAnchorClickHandlerRegistration.removeHandler();
                }
                this.lastPageAnchorClickHandlerRegistration = this.lastPageAnchor.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent clickEvent) {
                        clickEvent.stopPropagation();
                        if (isLastPageEnabled) {
                            EntitiesListView.this.presenter.onGoToLastPage();
                        }
                    }
                });
            }
            if (total == null || total == 0) {
                this.totalBadge.setVisible(false);
            } else {
                String t = UsersManagementWidgetsConstants.INSTANCE.total() + " " + total.toString() + " " + this.presenter.getEntityType();
                this.totalText.setText(t);
                this.totalBadge.setVisible(true);
            }
        }
        this.pagination.setVisible(existsPagination);
    }

    static interface EntitiesListViewStyle
    extends CssResource {
        public String entityPanel();

        public String entityGroup();

        public String entitiesList();

        public String entityListTitle();

        public String entityListButton();

        public String left();
    }

    static interface EntitiesListViewBinder
    extends UiBinder<Row, EntitiesListView> {
    }
}

