/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.explorer;

import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.Group;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.events.AddUsersToGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.NewGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.ReadGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.explorer.AbstractEntityExplorer;
import org.uberfire.ext.security.management.client.widgets.management.explorer.EntitiesExplorerView;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.ext.security.management.impl.SearchRequestImpl;

@Dependent
public class GroupsExplorer
extends AbstractEntityExplorer<Group> {
    private Event<ReadGroupEvent> readGroupEvent;
    private Event<NewGroupEvent> newGroupEvent;

    @Inject
    public GroupsExplorer(ClientUserSystemManager userSystemManager, Event<OnErrorEvent> errorEvent, LoadingBox loadingBox, EntitiesList<Group> entitiesList, EntitiesExplorerView view, Event<ReadGroupEvent> readGroupEvent, Event<NewGroupEvent> newGroupEvent) {
        super(userSystemManager, errorEvent, loadingBox, entitiesList, view);
        this.readGroupEvent = readGroupEvent;
        this.newGroupEvent = newGroupEvent;
    }

    @Override
    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    protected String getEmptyText() {
        return UsersManagementWidgetsConstants.INSTANCE.noGroups();
    }

    @Override
    protected String getEntityType() {
        return UsersManagementWidgetsConstants.INSTANCE.groups();
    }

    @Override
    protected String getTitle() {
        return UsersManagementWidgetsConstants.INSTANCE.group();
    }

    @Override
    protected String getEntityId(Group entity) {
        return entity.getName();
    }

    @Override
    protected String getEntityName(Group entity) {
        return entity.getName();
    }

    @Override
    protected boolean canSearch() {
        return this.userSystemManager.isGroupCapabilityEnabled(Capability.CAN_SEARCH_GROUPS);
    }

    @Override
    protected boolean canCreate() {
        return this.userSystemManager.isGroupCapabilityEnabled(Capability.CAN_ADD_GROUP);
    }

    @Override
    protected boolean canRead() {
        return this.userSystemManager.isGroupCapabilityEnabled(Capability.CAN_READ_GROUP);
    }

    @Override
    protected void fireReadEvent(String identifier) {
        this.readGroupEvent.fire((Object)new ReadGroupEvent(identifier));
    }

    @Override
    protected void showCreate() {
        this.newGroupEvent.fire((Object)new NewGroupEvent());
    }

    @Override
    protected void showSearch() {
        this.showLoadingView();
        this.userSystemManager.groups((RemoteCallback)new RemoteCallback<AbstractEntityManager.SearchResponse<Group>>(){

            public void callback(AbstractEntityManager.SearchResponse<Group> response) {
                if (response != null) {
                    EntitiesList.Callback callback = GroupsExplorer.this.createCallback();
                    GroupsExplorer.this.entitiesList.show(response, callback);
                    GroupsExplorer.this.view.show(GroupsExplorer.this.context, GroupsExplorer.this.viewCallback);
                    GroupsExplorer.this.hideLoadingView();
                }
            }
        }, this.errorCallback).search((AbstractEntityManager.SearchRequest)new SearchRequestImpl(this.searchPattern, this.currentPage, this.pageSize, this.context != null ? this.context.getConstrainedEntities() : null));
    }

    void onGroupDeleted(@Observes DeleteGroupEvent deleteGroupEvent) {
        this.attemptToShowSearch();
    }

    void onAddUsersToGroup(@Observes AddUsersToGroupEvent addUsersToGroupEvent) {
        this.attemptToShowSearch();
    }

    void onGroupCreated(@Observes CreateGroupEvent createGroupEvent) {
        this.attemptToShowSearch();
    }
}

