/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.explorer;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.LabelType;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.explorer.EntitiesExplorerView;
import org.uberfire.ext.security.management.client.widgets.management.explorer.ExplorerViewContext;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;

public abstract class AbstractEntityExplorer<T>
implements IsWidget {
    protected static final int PAGE_SIZE = 15;
    protected static final String SEARCH_PATTERN_ALL = "";
    public EntitiesExplorerView view;
    ClientUserSystemManager userSystemManager;
    Event<OnErrorEvent> errorEvent;
    LoadingBox loadingBox;
    protected final ErrorCallback<Message> errorCallback = new ErrorCallback<Message>(){

        public boolean error(Message message, Throwable throwable) {
            AbstractEntityExplorer.this.showError(throwable);
            return false;
        }
    };
    EntitiesList<T> entitiesList;
    int pageSize = 15;
    String searchPattern = "";
    int currentPage = 1;
    protected EntitiesExplorerView.ViewCallback viewCallback = new EntitiesExplorerView.ViewCallback(){

        @Override
        public void onSearch(String pattern) {
            AbstractEntityExplorer.this.searchPattern = pattern != null ? pattern : AbstractEntityExplorer.SEARCH_PATTERN_ALL;
            AbstractEntityExplorer.this.currentPage = 1;
            if (pattern == null || pattern.trim().length() == 0) {
                AbstractEntityExplorer.this.view.clearSearch();
            }
            AbstractEntityExplorer.this.showSearch();
        }

        @Override
        public void onRefresh() {
            AbstractEntityExplorer.this.currentPage = 1;
            AbstractEntityExplorer.this.showSearch();
        }

        @Override
        public void onCreate() {
            AbstractEntityExplorer.this.showCreate();
        }
    };
    ExplorerViewContext context;
    Set<String> selected;

    @Inject
    public AbstractEntityExplorer(ClientUserSystemManager userSystemManager, Event<OnErrorEvent> errorEvent, LoadingBox loadingBox, EntitiesList<T> entitiesList, EntitiesExplorerView view) {
        this.userSystemManager = userSystemManager;
        this.errorEvent = errorEvent;
        this.loadingBox = loadingBox;
        this.entitiesList = entitiesList;
        this.view = view;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    protected abstract String getEmptyText();

    protected abstract String getEntityType();

    protected abstract String getTitle();

    protected abstract String getEntityId(T var1);

    protected abstract String getEntityName(T var1);

    protected abstract boolean canSearch();

    protected abstract boolean canCreate();

    protected abstract boolean canRead();

    protected abstract void showSearch();

    protected abstract void showCreate();

    @PostConstruct
    public void init() {
        this.entitiesList.setPageSize(this.pageSize);
        this.entitiesList.setEmptyEntitiesText(this.getEmptyText());
        this.view.configure(this.getTitle(), this.entitiesList.view);
    }

    public void show() {
        this.show(null);
    }

    public void show(ExplorerViewContext context) {
        this.context = context;
        if (this.context == null) {
            this.context = new ExplorerViewContext();
        }
        this.context.setParent(this.createParentContext());
        this.selected = this.context.getSelectedEntities();
        if (this.canSearch()) {
            this.showSearch();
        } else {
            this.view.showMessage(LabelType.WARNING, UsersManagementWidgetsConstants.INSTANCE.doesNotHavePrivileges());
        }
    }

    public Set<String> getSelectedEntities() {
        return this.nullSafe(this.selected);
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected EntitiesList.Callback<T> createCallback() {
        return new EntitiesList.Callback<T>(){

            @Override
            public String getEntityType() {
                return AbstractEntityExplorer.this.getEntityType();
            }

            @Override
            public boolean canRead() {
                return AbstractEntityExplorer.this.context.canRead();
            }

            @Override
            public boolean canRemove() {
                return AbstractEntityExplorer.this.context.canDelete();
            }

            @Override
            public boolean canSelect() {
                return AbstractEntityExplorer.this.context.canSelect();
            }

            @Override
            public boolean isSelected(String id) {
                return AbstractEntityExplorer.this.selected != null && AbstractEntityExplorer.this.selected.contains(id);
            }

            @Override
            public String getIdentifier(T entity) {
                return AbstractEntityExplorer.this.getEntityId(entity);
            }

            @Override
            public String getTitle(T entity) {
                return AbstractEntityExplorer.this.getEntityName(entity);
            }

            @Override
            public void onReadEntity(String identifier) {
                AbstractEntityExplorer.this.fireReadEvent(identifier);
            }

            @Override
            public void onRemoveEntity(String identifier) {
            }

            @Override
            public void onSelectEntity(String identifier, boolean isSelected) {
                if (isSelected) {
                    if (AbstractEntityExplorer.this.selected == null) {
                        AbstractEntityExplorer.this.selected = new HashSet<String>(1);
                    }
                    AbstractEntityExplorer.this.selected.add(identifier);
                } else if (AbstractEntityExplorer.this.selected != null) {
                    AbstractEntityExplorer.this.selected.remove(identifier);
                }
            }

            @Override
            public void onChangePage(int currentPage, int goToPage) {
                AbstractEntityExplorer.this.currentPage = goToPage;
                AbstractEntityExplorer.this.showSearch();
            }
        };
    }

    protected void fireReadEvent(String identifier) {
    }

    protected EntitiesExplorerView.ViewContext createParentContext() {
        boolean canSelect = false;
        return new EntitiesExplorerView.ViewContext(){

            @Override
            public boolean canSearch() {
                return AbstractEntityExplorer.this.canSearch();
            }

            @Override
            public boolean canCreate() {
                return AbstractEntityExplorer.this.canCreate();
            }

            @Override
            public boolean canRead() {
                return AbstractEntityExplorer.this.canRead();
            }

            @Override
            public boolean canDelete() {
                return false;
            }

            @Override
            public boolean canSelect() {
                return false;
            }

            @Override
            public Set<String> getSelectedEntities() {
                return AbstractEntityExplorer.this.selected;
            }

            @Override
            public Set<String> getConstrainedEntities() {
                return new HashSet<String>();
            }
        };
    }

    protected void showLoadingView() {
        this.loadingBox.show();
    }

    protected Set<String> nullSafe(Set<String> set) {
        return set != null ? Collections.unmodifiableSet(set) : null;
    }

    protected void hideLoadingView() {
        this.loadingBox.hide();
    }

    protected boolean hasContext() {
        return null != this.context;
    }

    protected void attemptToShowSearch() {
        if (this.hasContext()) {
            this.showSearch();
        }
    }

    protected void showError(Throwable throwable) {
        this.hideLoadingView();
        this.errorEvent.fire((Object)new OnErrorEvent(this, throwable));
    }

    public void clear() {
        this.context = null;
        this.searchPattern = SEARCH_PATTERN_ALL;
        this.currentPage = 1;
        this.view.clear();
    }
}

