/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.role.workflow;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.event.Event;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.security.shared.api.Role;
import org.uberfire.backend.authz.AuthorizationService;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.editor.role.RoleEditorDriver;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.editor.role.RoleEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.ContextualEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveRoleEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.mvp.Command;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class BaseRoleEditorWorkflow
implements IsWidget {
    public EntityWorkflowView view;
    protected ClientUserSystemManager userSystemManager;
    protected Caller<AuthorizationService> authorizationService;
    protected PermissionManager permissionManager;
    protected Event<OnErrorEvent> errorEvent;
    protected Event<NotificationEvent> workbenchNotification;
    protected Event<SaveRoleEvent> saveRoleEvent;
    protected ConfirmBox confirmBox;
    protected RoleEditor roleEditor;
    protected RoleEditorDriver roleEditorDriver;
    protected LoadingBox loadingBox;
    protected final ErrorCallback<Message> errorCallback = (message, throwable) -> {
        this.hideLoadingBox();
        this.showError(throwable);
        return false;
    };
    protected Role role;
    protected boolean isDirty;

    public BaseRoleEditorWorkflow(ClientUserSystemManager userSystemManager, Caller<AuthorizationService> authorizationService, PermissionManager permissionManager, Event<OnErrorEvent> errorEvent, Event<NotificationEvent> workbenchNotification, Event<SaveRoleEvent> saveRoleEvent, ConfirmBox confirmBox, RoleEditor roleEditor, RoleEditorDriver roleEditorDriver, LoadingBox loadingBox, EntityWorkflowView view) {
        this.userSystemManager = userSystemManager;
        this.authorizationService = authorizationService;
        this.permissionManager = permissionManager;
        this.errorEvent = errorEvent;
        this.workbenchNotification = workbenchNotification;
        this.saveRoleEvent = saveRoleEvent;
        this.confirmBox = confirmBox;
        this.roleEditor = roleEditor;
        this.roleEditorDriver = roleEditorDriver;
        this.loadingBox = loadingBox;
        this.view = view;
        this.isDirty = false;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public RoleEditor getRoleEditor() {
        return this.roleEditor;
    }

    public void clear() {
        this.view.clearNotifications();
        this.roleEditor.clear();
        this.isDirty = false;
        this.role = null;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void doShow(String roleName) {
        assert (roleName != null);
        this.doInitView();
        this.checkDirty(() -> this.doLoad(roleName));
    }

    protected void doLoad(String roleName) {
        this.checkDirty(this::clear);
        this.showLoadingBox();
        this.userSystemManager.roles(o -> {
            this.hideLoadingBox();
            this.role = o;
            assert (this.role != null);
            this.edit();
        }, this.errorCallback).get(roleName);
    }

    protected void onSave() {
        this.doSave();
    }

    protected void onCancel() {
        this.doShow(this.role.getName());
    }

    protected void doInitView() {
        this.view.setWidget((IsWidget)this.roleEditor.view).setCancelButtonVisible(true).setSaveButtonVisible(true).setSaveButtonEnabled(this.isDirty).setSaveButtonText(this.getSaveButtonText()).setCallback(new EntityWorkflowView.Callback(){

            @Override
            public void onSave() {
                BaseRoleEditorWorkflow.this.onSave();
            }

            @Override
            public void onCancel() {
                BaseRoleEditorWorkflow.this.onCancel();
            }
        });
    }

    protected String getSaveButtonText() {
        return UsersManagementWidgetsConstants.INSTANCE.saveChanges();
    }

    protected void showNotification(String message) {
        this.view.showNotification(message);
    }

    protected void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        this.view.setSaveButtonVisible(isDirty);
        this.view.setSaveButtonEnabled(isDirty);
        this.view.setCancelButtonVisible(true);
        if (isDirty) {
            this.view.showNotification(UsersManagementWidgetsConstants.INSTANCE.roleModified(this.role.getName()));
        } else {
            this.view.clearNotifications();
        }
    }

    protected void edit() {
        this.roleEditorDriver.edit(this.role, (org.uberfire.ext.security.management.client.editor.role.RoleEditor)this.roleEditor);
        this.view.setCancelButtonVisible(false);
        this.view.setSaveButtonVisible(false);
    }

    protected void doSave() {
        assert (this.role != null);
        boolean isValid = this.roleEditorDriver.flush();
        this.role = this.roleEditorDriver.getValue();
        PermissionCollection rolePermissions = this.roleEditorDriver.getPermissions();
        PerspectiveActivity homePerspective = this.roleEditorDriver.getHomePerspective();
        int rolePriority = this.roleEditorDriver.getRolePriority();
        if (!isValid) {
            throw new RuntimeException("Role must be valid before updating it.");
        }
        this.showLoadingBox();
        AuthorizationPolicy authzPolicy = this.permissionManager.getAuthorizationPolicy();
        authzPolicy.setHomePerspective(this.role, homePerspective.getIdentifier());
        authzPolicy.setPriority(this.role, rolePriority);
        authzPolicy.setPermissions(this.role, rolePermissions);
        ((AuthorizationService)this.authorizationService.call(r -> {
            this.hideLoadingBox();
            this.isDirty = false;
            this.workbenchNotification.fire((Object)new NotificationEvent(UsersManagementWidgetsConstants.INSTANCE.roleSaved(this.role.getName()), NotificationEvent.NotificationType.SUCCESS));
            this.saveRoleEvent.fire((Object)new SaveRoleEvent(this.role.getName()));
            this.doShow(this.role.getName());
        }, this.errorCallback)).savePolicy(authzPolicy);
    }

    protected boolean checkEventContext(ContextualEvent contextualEvent, Object context) {
        return contextualEvent != null && contextualEvent.getContext() != null && contextualEvent.getContext().equals(context);
    }

    void showError(Throwable throwable) {
        this.errorEvent.fire((Object)new OnErrorEvent(this, throwable));
    }

    protected void checkDirty(Command callback) {
        if (this.isDirty) {
            this.confirmBox.show(UsersManagementWidgetsConstants.INSTANCE.confirmAction(), UsersManagementWidgetsConstants.INSTANCE.roleIsDirty(), () -> {
                this.isDirty = false;
                callback.execute();
            }, () -> {});
        } else {
            callback.execute();
        }
    }

    protected void showLoadingBox() {
        this.loadingBox.show();
    }

    protected void hideLoadingBox() {
        this.loadingBox.hide();
    }
}

