/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user;

import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.editor.AssignedEntitiesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedEntitiesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.events.OnRemoveUserRoleEvent;
import org.uberfire.ext.security.management.client.widgets.management.list.RolesList;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;

@Dependent
public class UserAssignedRolesExplorer
extends UserAssignedEntitiesExplorer<Role>
implements org.uberfire.ext.security.management.client.editor.user.UserAssignedRolesExplorer {
    Event<OnRemoveUserRoleEvent> removeUserRoleEvent;

    @Inject
    public UserAssignedRolesExplorer(ClientUserSystemManager userSystemManager, ConfirmBox confirmBox, RolesList rolesList, AssignedEntitiesExplorer view, Event<OnRemoveUserRoleEvent> removeUserRoleEvent) {
        super(userSystemManager, confirmBox, rolesList, view);
        this.removeUserRoleEvent = removeUserRoleEvent;
    }

    @Override
    protected String getEmptyText() {
        return UsersManagementWidgetsConstants.INSTANCE.userHasNoRoles();
    }

    @Override
    protected String getEntityType() {
        return UsersManagementWidgetsConstants.INSTANCE.rolesAssigned();
    }

    @Override
    protected String getTitle() {
        return null;
    }

    @Override
    protected String getEntityId(Role entity) {
        return entity.getName();
    }

    @Override
    protected String getEntityName(Role entity) {
        return entity.getName();
    }

    @Override
    protected String getEnsureRemoveText() {
        return UsersManagementWidgetsConstants.INSTANCE.ensureRemoveRoleFromUser();
    }

    @Override
    protected boolean canAssignEntities() {
        boolean canAssignRoles = this.userSystemManager.isUserCapabilityEnabled(Capability.CAN_ASSIGN_ROLES);
        return this.isEditMode && canAssignRoles;
    }

    @Override
    protected void open(User user) {
        Set uRoles = user.getRoles();
        for (Role _role : uRoles) {
            this.entities.add(_role);
        }
        super.open(user);
    }

    @Override
    protected void doShow() {
        this.entitiesList.show(this.entities, this.getCallback());
    }

    @Override
    protected void removeEntity(String name) {
        Iterator roles = this.entities.iterator();
        while (roles.hasNext()) {
            Role g = (Role)roles.next();
            if (!g.getName().equals(name)) continue;
            roles.remove();
        }
        this.doShow();
        this.removeUserRoleEvent.fire((Object)new OnRemoveUserRoleEvent(this, name));
    }
}

