/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.role.workflow;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.backend.authz.AuthorizationService;
import org.uberfire.client.authz.PerspectiveAction;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.editor.role.RoleEditorDriver;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.editor.role.RoleEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.role.workflow.BaseRoleEditorWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.HomePerspectiveChangedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnEditEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionChangedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionNodeAddedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionNodeRemovedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PriorityChangedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveRoleEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class RoleEditorWorkflow
extends BaseRoleEditorWorkflow {
    private PerspectiveActivity selectedHomePerspective = null;

    @Inject
    public RoleEditorWorkflow(ClientUserSystemManager userSystemManager, Caller<AuthorizationService> authorizationService, PermissionManager permissionManager, Event<OnErrorEvent> errorEvent, Event<NotificationEvent> workbenchNotification, Event<SaveRoleEvent> saveUserEvent, ConfirmBox confirmBox, RoleEditor roleEditor, RoleEditorDriver roleEditorDriver, LoadingBox loadingBox, EntityWorkflowView view) {
        super(userSystemManager, authorizationService, permissionManager, errorEvent, workbenchNotification, saveUserEvent, confirmBox, roleEditor, roleEditorDriver, loadingBox, view);
    }

    public void show(String roleName) {
        this.doShow(roleName);
    }

    @Override
    protected void edit() {
        super.edit();
        this.selectedHomePerspective = this.roleEditor.getAclSettings().getHomePerspective();
        if (this.isPerspectiveReadDenied(this.selectedHomePerspective)) {
            this.showNotification(UsersManagementWidgetsConstants.INSTANCE.homePerspectiveReadDenied());
        }
    }

    void onEditRoleEvent(@Observes OnEditEvent onEditEvent) {
        if (this.checkEventContext(onEditEvent, this.roleEditor)) {
            this.edit();
        }
    }

    void onHomePerspectiveChangedEvent(@Observes HomePerspectiveChangedEvent event) {
        if (this.checkEventContext(event, this.roleEditor.getAclSettings())) {
            this.selectedHomePerspective = event.getPerspective();
            this.checkStatus();
        }
    }

    void onPriorityChangedEvent(@Observes PriorityChangedEvent event) {
        if (this.checkEventContext(event, this.roleEditor.getAclSettings())) {
            this.checkStatus();
        }
    }

    void onPermissionChangedEvent(@Observes PermissionChangedEvent event) {
        if (this.checkEventContext(event, this.roleEditor.getAclEditor())) {
            this.checkStatus();
        }
    }

    void onPermissionAddedEvent(@Observes PermissionNodeAddedEvent event) {
        if (this.checkEventContext(event, this.roleEditor.getAclEditor())) {
            this.setDirty(true);
            this.checkStatus();
        }
    }

    void onPermissionRemovedEvent(@Observes PermissionNodeRemovedEvent event) {
        if (this.checkEventContext(event, this.roleEditor.getAclEditor())) {
            this.checkStatus();
        }
    }

    protected void checkStatus() {
        boolean readDenied = this.isPerspectiveReadDenied(this.selectedHomePerspective);
        if (readDenied) {
            this.setDirty(false);
            this.showNotification(UsersManagementWidgetsConstants.INSTANCE.homePerspectiveReadDenied());
        } else {
            this.setDirty(true);
        }
    }

    protected boolean isPerspectiveReadDenied(PerspectiveActivity perspectiveActivity) {
        Permission p;
        if (perspectiveActivity == null) {
            return false;
        }
        PermissionCollection permissionCollection = this.roleEditor.permissions();
        Permission existing = permissionCollection.get((p = this.permissionManager.createPermission((Resource)perspectiveActivity, PerspectiveAction.READ, false)).getName());
        if (existing != null) {
            return existing.getResult().equals((Object)AuthorizationResult.ACCESS_DENIED);
        }
        return permissionCollection.implies(p);
    }
}

