/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.group;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import org.jboss.errai.security.shared.api.Group;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLSettings;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLViewer;
import org.uberfire.ext.security.management.client.widgets.management.events.OnDeleteEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnEditEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnShowEvent;
import org.uberfire.security.authz.PermissionCollection;

@Dependent
public class GroupEditor
implements IsWidget,
org.uberfire.ext.security.management.client.editor.group.GroupEditor {
    public View view;
    ClientUserSystemManager userSystemManager;
    Event<OnDeleteEvent> onDeleteEvent;
    Event<OnEditEvent> onEditEvent;
    Event<OnShowEvent> onShowEvent;
    ACLSettings aclSettings;
    ACLViewer aclViewer;
    ACLEditor aclEditor;
    Group group;
    boolean isEditMode;

    @Inject
    public GroupEditor(ClientUserSystemManager userSystemManager, Event<OnEditEvent> onEditEvent, Event<OnShowEvent> onShowEvent, Event<OnDeleteEvent> onDeleteEvent, ACLSettings aclSettings, ACLViewer aclViewer, ACLEditor aclEditor, View view) {
        this.userSystemManager = userSystemManager;
        this.onDeleteEvent = onDeleteEvent;
        this.aclSettings = aclSettings;
        this.aclViewer = aclViewer;
        this.aclEditor = aclEditor;
        this.onEditEvent = onEditEvent;
        this.onShowEvent = onShowEvent;
        this.view = view;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.setACLSettings(this.aclSettings);
    }

    public String name() {
        return this.group.getName();
    }

    public PerspectiveActivity homePerspective() {
        return this.aclSettings.getHomePerspective();
    }

    public int groupPriority() {
        return this.aclSettings.getPriority();
    }

    public PermissionCollection permissions() {
        return this.aclEditor.getPermissions();
    }

    public ACLSettings getAclSettings() {
        return this.aclSettings;
    }

    public ACLEditor getAclEditor() {
        return this.aclEditor;
    }

    public void show(Group group) {
        this.clear();
        this.isEditMode = false;
        this.open(group);
        this.onShowEvent.fire((Object)new OnShowEvent(this, group));
    }

    public void edit(Group group) {
        this.clear();
        this.isEditMode = true;
        this.open(group);
    }

    public void clear() {
        this.view.clear();
        this.group = null;
    }

    public void flush() {
        assert (this.group != null);
        assert (this.isEditMode);
    }

    public Group getValue() {
        return this.group;
    }

    public void setViolations(Set<ConstraintViolation<Group>> violations) {
    }

    boolean canDelete() {
        return this.userSystemManager.isGroupCapabilityEnabled(Capability.CAN_DELETE_GROUP);
    }

    void onDelete() {
        this.onDeleteEvent.fire((Object)new OnDeleteEvent(this, this.group));
    }

    void onEdit() {
        this.onEditEvent.fire((Object)new OnEditEvent(this, this.group));
    }

    protected void open(Group group) {
        assert (group != null);
        this.group = group;
        String name = group.getName();
        this.view.show(name);
        this.view.setEditButtonVisible(!this.isEditMode);
        this.view.setDeleteButtonVisible(this.isEditMode && this.canDelete());
        if (this.isEditMode) {
            this.aclSettings.edit(group);
            this.aclEditor.edit(group);
            this.view.editACL(this.aclEditor);
        } else {
            this.aclSettings.show(group);
            this.aclViewer.show(group);
            this.view.showACL(this.aclViewer);
        }
    }

    public static interface View
    extends UberView<GroupEditor> {
        public View show(String var1);

        public View setEditButtonVisible(boolean var1);

        public View setDeleteButtonVisible(boolean var1);

        public View clear();

        public View setACLSettings(IsWidget var1);

        public View showACL(IsWidget var1);

        public View editACL(IsWidget var1);
    }
}

