/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionNodeViewer;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionWidgetFactory;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTree;
import org.uberfire.security.client.authz.tree.PermissionTreeFactory;

@Dependent
public class ACLViewer
implements IsWidget {
    View view;
    PermissionWidgetFactory nodeWidgetFactory;
    PermissionTreeFactory permissionTreeFactory;
    PermissionTree permissionTree;

    @Inject
    public ACLViewer(View view, PermissionWidgetFactory nodeWidgetFactory, PermissionTreeFactory permissionTreeFactory) {
        this.view = view;
        this.nodeWidgetFactory = nodeWidgetFactory;
        this.permissionTreeFactory = permissionTreeFactory;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void show(Role role) {
        this.show(this.permissionTreeFactory.createPermissionTree(role));
    }

    public void show(Group group) {
        this.show(this.permissionTreeFactory.createPermissionTree(group));
    }

    public void show(User user) {
        this.show(this.permissionTreeFactory.createPermissionTree(user, VotingStrategy.PRIORITY));
    }

    private void show(PermissionTree tree) {
        this.view.clear();
        this.permissionTree = tree;
        if (tree != null) {
            List rootNodeList = tree.getRootNodes();
            for (PermissionNode rootNode : rootNodeList) {
                PermissionNodeViewer rootNodeViewer = this.nodeWidgetFactory.createViewer(rootNode);
                rootNodeViewer.show(rootNode);
                this.view.addRootNodeWidget(rootNodeViewer);
            }
        }
    }

    public static interface View
    extends UberView<ACLViewer> {
        public void clear();

        public void addRootNodeWidget(IsWidget var1);
    }
}

