/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.model.validators;

import java.util.Arrays;
import java.util.List;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.ext.properties.editor.model.validators.PropertyFieldValidator;

@Portable
public class ColorValidator
implements PropertyFieldValidator {
    public static final List<Character> _hexLetters = Arrays.asList(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'));

    public static boolean isValid(String aColor) {
        try {
            String color = aColor.trim().toLowerCase();
            if (color.length() != 6) {
                return false;
            }
            for (int i = 0; i < color.length(); ++i) {
                char c = color.charAt(i);
                if (Character.isDigit(c) || _hexLetters.contains(Character.valueOf(c))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean validate(Object value) {
        if (value == null) {
            return false;
        }
        return ColorValidator.isValid(value.toString());
    }

    @Override
    public String getValidatorErrorMessage() {
        return "Value must be valid color. Example: 'FFFFFF'";
    }
}

