/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.wizards;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gwtbootstrap3.client.ui.NavPills;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.AbstractWizard;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageTitle;
import org.uberfire.ext.widgets.core.client.wizards.WizardPopupFooter;
import org.uberfire.ext.widgets.core.client.wizards.WizardViewImpl;

@RunWith(value=GwtMockitoTestRunner.class)
public class WizardViewImplTest {
    @Mock
    NavPills sideBar;
    @Mock
    WizardPopupFooter footer;
    @Mock
    AbstractWizard presenter;
    @Mock
    SyncBeanManager iocBeanManager;
    List<WizardPageTitle> pageTitleWidgets = new ArrayList<WizardPageTitle>();
    @Mock
    WizardViewImpl view;

    @Before
    public void init() {
        this.view.sideBar = this.sideBar;
        this.view.footer = this.footer;
        this.view.iocBeanManager = this.iocBeanManager;
        this.view.pageTitleWidgets = this.pageTitleWidgets;
        ((WizardViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setCompletionStatus(Mockito.anyBoolean());
        ((WizardViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).onUnload();
        ((WizardViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).setPageTitles(Mockito.anyList());
        ((WizardViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).hide();
    }

    @Test
    public void testSetCompletionStatusTrue() {
        this.view.setCompletionStatus(true);
        ((WizardPopupFooter)Mockito.verify((Object)this.view.footer, (VerificationMode)Mockito.times((int)1))).enableFinishButton(true);
    }

    @Test
    public void testSetCompletionStatusFalse() {
        this.view.setCompletionStatus(false);
        ((WizardPopupFooter)Mockito.verify((Object)this.view.footer, (VerificationMode)Mockito.times((int)1))).enableFinishButton(false);
    }

    @Test
    public void testOnUnload() {
        ((WizardViewImpl)Mockito.doReturn((Object)this.presenter).when((Object)this.view)).getPresenter();
        this.view.onUnload();
        ((AbstractWizard)Mockito.verify((Object)this.presenter)).close();
        ((WizardViewImpl)Mockito.verify((Object)this.view)).parentOnUnload();
    }

    @Test
    public void testHide() {
        WizardPage firstWizardPageMock = (WizardPage)Mockito.mock(WizardPage.class);
        WizardPage secondWizardPageMock = (WizardPage)Mockito.mock(WizardPage.class);
        WizardPageTitle firstTitleMock = (WizardPageTitle)Mockito.mock(WizardPageTitle.class);
        WizardPageTitle secondTitleMock = (WizardPageTitle)Mockito.mock(WizardPageTitle.class);
        ((WizardViewImpl)Mockito.doReturn((Object)firstTitleMock).when((Object)this.view)).makeWizardPageTitle(firstWizardPageMock);
        ((WizardViewImpl)Mockito.doReturn((Object)secondTitleMock).when((Object)this.view)).makeWizardPageTitle(secondWizardPageMock);
        this.view.setPageTitles(Arrays.asList(firstWizardPageMock, secondWizardPageMock));
        Assert.assertEquals((long)2L, (long)this.pageTitleWidgets.size());
        this.view.hide();
        ((SyncBeanManager)Mockito.verify((Object)this.iocBeanManager)).destroyBean((Object)firstTitleMock);
        ((SyncBeanManager)Mockito.verify((Object)this.iocBeanManager)).destroyBean((Object)secondTitleMock);
        Assert.assertEquals((long)0L, (long)this.pageTitleWidgets.size());
    }
}

