/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.tree;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.tree.Tree;
import org.uberfire.ext.widgets.core.client.tree.TreeItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class TreeTest {
    @Mock
    private IsWidget widget;
    @Mock
    private FlowPanel container;
    @Mock
    private FlowPanel content;
    private Tree<TreeItem> testedTree;

    @Before
    public void setup() {
        this.testedTree = new Tree(() -> this.container);
    }

    @Test
    public void testIsEmpty() {
        Assert.assertEquals((Object)this.testedTree.isEmpty(), (Object)true);
    }

    @Test
    public void testAddItem() {
        TreeItem item = (TreeItem)Mockito.mock(TreeItem.class);
        this.testedTree.addItem(item);
        item.setTree(this.testedTree);
        ((FlowPanel)Mockito.verify((Object)this.container, (VerificationMode)Mockito.times((int)1))).add((Widget)Matchers.eq((Object)item));
    }

    @Test
    public void testGetItem() {
        TreeItem item1 = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)this.container.getWidgetCount()).thenReturn((Object)1);
        Mockito.when((Object)this.container.getWidget(Matchers.eq((int)0))).thenReturn((Object)item1);
        this.testedTree.addItem(item1);
        ((FlowPanel)Mockito.verify((Object)this.container, (VerificationMode)Mockito.times((int)1))).add((Widget)Matchers.eq((Object)item1));
        Assert.assertEquals((Object)this.testedTree.getItem(0), (Object)item1);
    }

    @Test
    public void testGetItemByUuuid() {
        TreeItem item1 = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)item1.getUuid()).thenReturn((Object)"test");
        Mockito.when((Object)item1.getItemByUuid("test")).thenReturn((Object)item1);
        Mockito.when((Object)this.container.getWidgetCount()).thenReturn((Object)1);
        Mockito.when((Object)this.container.getWidget(Matchers.eq((int)0))).thenReturn((Object)item1);
        this.testedTree.addItem(item1);
        ((FlowPanel)Mockito.verify((Object)this.container, (VerificationMode)Mockito.times((int)1))).add((Widget)Matchers.eq((Object)item1));
        Assert.assertEquals((Object)this.testedTree.getItem(0), (Object)item1);
        TreeItem item = this.testedTree.getItemByUuid("test");
        Assert.assertEquals((Object)item1, (Object)item);
    }

    @Test
    public void testGetItemByUuuidWithParent() {
        TreeItem item1 = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)item1.getUuid()).thenReturn((Object)"test");
        Mockito.when((Object)item1.getItemByUuid("test")).thenReturn((Object)item1);
        TreeItem parent = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)parent.getUuid()).thenReturn((Object)"parent");
        Mockito.when((Object)parent.getChild(0)).thenReturn((Object)item1);
        Mockito.when((Object)parent.getChildCount()).thenReturn((Object)1);
        Mockito.when((Object)parent.getItemByUuid("parent")).thenReturn((Object)parent);
        Mockito.when((Object)this.container.getWidgetCount()).thenReturn((Object)1);
        Mockito.when((Object)this.container.getWidget(Matchers.eq((int)0))).thenReturn((Object)item1);
        this.testedTree.addItem(parent);
        ((FlowPanel)Mockito.verify((Object)this.container, (VerificationMode)Mockito.times((int)1))).add((Widget)Matchers.eq((Object)parent));
        Assert.assertEquals((Object)this.testedTree.getItem(0), (Object)item1);
        TreeItem item = this.testedTree.getItemByUuid("test");
        Assert.assertEquals((Object)item1, (Object)item);
    }

    @Test
    public void testRemoveItem() {
        TreeItem item1 = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)this.container.getWidgetCount()).thenReturn((Object)1);
        Mockito.when((Object)this.container.getWidget(Matchers.eq((int)0))).thenReturn((Object)item1);
        this.testedTree.addItem(item1);
        this.testedTree.removeItem(item1);
        ((FlowPanel)Mockito.verify((Object)this.container, (VerificationMode)Mockito.times((int)1))).remove((Widget)item1);
    }

    @Test
    public void testGetItems() {
        TreeItem item1 = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)this.container.getWidgetCount()).thenReturn((Object)1);
        Mockito.when((Object)this.container.getWidget(Matchers.eq((int)0))).thenReturn((Object)item1);
        this.testedTree.addItem(item1);
        this.testedTree.getItems().iterator().hasNext();
        ((FlowPanel)Mockito.verify((Object)this.container, (VerificationMode)Mockito.times((int)1))).getWidgetCount();
        int[] idx = new int[]{0};
        TreeItem[] item = new TreeItem[1];
        this.testedTree.getItems().forEach(i -> {
            item[0] = i;
            idx[0] = idx[0] + 1;
        });
        Assert.assertEquals((long)idx[0], (long)1L);
        Assert.assertEquals((Object)item[0], (Object)item1);
    }

    @Test
    public void testGetSelectedItem() {
        TreeItem item1 = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)this.container.getWidgetCount()).thenReturn((Object)1);
        Mockito.when((Object)this.container.getWidget(Matchers.eq((int)0))).thenReturn((Object)item1);
        this.testedTree.addItem(item1);
        this.testedTree.setSelectedItem(item1);
        TreeItem itemGet = this.testedTree.getSelectedItem();
        Assert.assertEquals((Object)itemGet, (Object)item1);
    }
}

