/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.tree;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.tree.FSTreeItem;
import org.uberfire.ext.widgets.core.client.tree.Tree;
import org.uberfire.ext.widgets.core.client.tree.TreeItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class FSTreeItemTest {
    public static final String ROOT_VALUE = "root";
    public static final String ROOT_LABEL = "root";
    public static final String FOLDER_VALUE = "folder";
    public static final String FOLDER_LABEL = "folder";
    public static final String ITEM_VALUE = "item";
    public static final String ITEM_LABEL = "item";
    @Mock
    private UIObject uiObject;
    @Mock
    private IsWidget widget;
    @Mock
    private FlowPanel content;
    @Mock
    private FlowPanel item;
    @Mock
    private Tree<FSTreeItem> tree;
    private FSTreeItem testedRoot;
    private FSTreeItem testedContainer;
    private FSTreeItem testedItem;

    @Before
    public void setup() {
        Element element = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.content.getElement()).thenReturn((Object)element);
        Mockito.when((Object)element.getTitle()).thenReturn((Object)"title");
        Style styleItem = (Style)Mockito.mock(Style.class);
        Mockito.when((Object)element.getStyle()).thenReturn((Object)styleItem);
        Mockito.when((Object)this.uiObject.getTitle()).thenReturn((Object)"TITLE");
        Style style = (Style)Mockito.mock(Style.class);
        Mockito.when((Object)element.getStyle()).thenReturn((Object)style);
        this.testedRoot = new FSTreeItem(FSTreeItem.FSType.ROOT, "root", () -> this.content);
        this.testedRoot.setTree(this.tree);
        this.testedContainer = new FSTreeItem(FSTreeItem.FSType.FOLDER, "folder", () -> this.content);
        this.testedItem = new FSTreeItem(FSTreeItem.FSType.ITEM, "item", () -> this.content);
    }

    @Test
    public void testGetters() {
        Assert.assertEquals((Object)TreeItem.State.CLOSE, (Object)this.testedRoot.getState());
        Assert.assertEquals((Object)FSTreeItem.FSType.ROOT, (Object)this.testedRoot.getFSType());
        Assert.assertEquals((Object)"root", (Object)this.testedRoot.getLabel());
        Assert.assertEquals((Object)"root", (Object)this.testedRoot.getUuid());
        Assert.assertEquals((Object)TreeItem.State.CLOSE, (Object)this.testedContainer.getState());
        Assert.assertEquals((Object)FSTreeItem.FSType.FOLDER, (Object)this.testedContainer.getFSType());
        Assert.assertEquals((Object)"folder", (Object)this.testedContainer.getLabel());
        Assert.assertEquals((Object)"folder", (Object)this.testedContainer.getUuid());
        Assert.assertEquals((Object)TreeItem.State.NONE, (Object)this.testedItem.getState());
        Assert.assertEquals((Object)FSTreeItem.FSType.ITEM, (Object)this.testedItem.getFSType());
        Assert.assertEquals((Object)"item", (Object)this.testedItem.getLabel());
        Assert.assertEquals((Object)"item", (Object)this.testedItem.getUuid());
    }

    @Test
    public void testAddItem() {
        FSTreeItem childTreeItem = (FSTreeItem)Mockito.mock(FSTreeItem.class);
        Mockito.when((Object)childTreeItem.getFSType()).thenReturn((Object)FSTreeItem.FSType.ITEM);
        FSTreeItem treeItem1 = (FSTreeItem)this.testedRoot.addItem((TreeItem)childTreeItem);
        Assert.assertEquals((Object)treeItem1, (Object)childTreeItem);
        ((FSTreeItem)Mockito.verify((Object)childTreeItem, (VerificationMode)Mockito.times((int)1))).setTree((Tree)Matchers.eq(this.tree));
        ((FSTreeItem)Mockito.verify((Object)childTreeItem, (VerificationMode)Mockito.times((int)1))).setParentItem((TreeItem)Matchers.eq((Object)this.testedRoot));
        ((FlowPanel)Mockito.verify((Object)this.content, (VerificationMode)Mockito.times((int)1))).add((Widget)Matchers.eq((Object)childTreeItem));
    }

    @Test
    public void testAddContainer() {
        FSTreeItem childTreeContainer = (FSTreeItem)Mockito.mock(FSTreeItem.class);
        Mockito.when((Object)childTreeContainer.getFSType()).thenReturn((Object)FSTreeItem.FSType.FOLDER);
        FSTreeItem treeItem1 = (FSTreeItem)this.testedRoot.addItem((TreeItem)childTreeContainer);
        Assert.assertEquals((Object)treeItem1, (Object)childTreeContainer);
        ((FSTreeItem)Mockito.verify((Object)childTreeContainer, (VerificationMode)Mockito.times((int)1))).setTree((Tree)Matchers.eq(this.tree));
        ((FSTreeItem)Mockito.verify((Object)childTreeContainer, (VerificationMode)Mockito.times((int)1))).setParentItem((TreeItem)Matchers.eq((Object)this.testedRoot));
        ((FlowPanel)Mockito.verify((Object)this.content, (VerificationMode)Mockito.times((int)1))).add((Widget)Matchers.eq((Object)childTreeContainer));
    }

    @Test
    public void testAddItemToContainer() {
        FSTreeItem childTreeContainer = (FSTreeItem)Mockito.mock(FSTreeItem.class);
        Mockito.when((Object)childTreeContainer.getFSType()).thenReturn((Object)FSTreeItem.FSType.FOLDER);
        FSTreeItem childTreeItem = (FSTreeItem)Mockito.mock(FSTreeItem.class);
        Mockito.when((Object)childTreeItem.getFSType()).thenReturn((Object)FSTreeItem.FSType.ITEM);
        FSTreeItem treeItem1 = (FSTreeItem)this.testedRoot.addItem((TreeItem)childTreeContainer);
        FSTreeItem treeItem2 = (FSTreeItem)this.testedContainer.addItem((TreeItem)treeItem1);
        Assert.assertEquals((Object)treeItem1, (Object)childTreeContainer);
        Assert.assertEquals((Object)treeItem2, (Object)treeItem1);
        ((FSTreeItem)Mockito.verify((Object)childTreeContainer, (VerificationMode)Mockito.times((int)1))).setTree((Tree)Matchers.eq(this.tree));
        ((FSTreeItem)Mockito.verify((Object)childTreeContainer, (VerificationMode)Mockito.times((int)1))).setParentItem((TreeItem)Matchers.eq((Object)this.testedRoot));
        ((FlowPanel)Mockito.verify((Object)this.content, (VerificationMode)Mockito.times((int)2))).add((Widget)treeItem2);
        ((FSTreeItem)Mockito.verify((Object)treeItem1, (VerificationMode)Mockito.times((int)1))).setTree((Tree)Matchers.eq(this.tree));
    }
}

