/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.tree;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.tree.Tree;
import org.uberfire.ext.widgets.core.client.tree.TreeItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class TreeItemTest {
    public static final String ROOT_VALUE = "rootValue";
    public static final String ROOT_LABEL = "rootLabel";
    public static final String CONTAINER_VALUE = "containerValue";
    public static final String CONTAINER_LABEL = "containerLabel";
    public static final String ITEM_VALUE = "itemValue";
    public static final String ITEM_LABEL = "itemLabel";
    @Mock
    private IsWidget widget;
    @Mock
    private FlowPanel content;
    @Mock
    private FlowPanel treeContainer;
    @Mock
    private Tree<TreeItem> tree;
    private TreeItem testedRoot;
    private TreeItem testedContainer;
    private TreeItem testedItem;

    @Before
    public void setup() {
        Element element = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.content.getElement()).thenReturn((Object)element);
        Style style = (Style)Mockito.mock(Style.class);
        Mockito.when((Object)element.getStyle()).thenReturn((Object)style);
        this.testedRoot = new TreeItem(TreeItem.Type.ROOT, ROOT_VALUE, ROOT_LABEL, this.widget, () -> this.content);
        this.testedRoot.setTree(this.tree);
        this.testedContainer = new TreeItem(TreeItem.Type.CONTAINER, CONTAINER_VALUE, CONTAINER_LABEL, this.widget, () -> this.content);
        this.testedItem = new TreeItem(TreeItem.Type.ITEM, ITEM_VALUE, ITEM_LABEL, this.widget, () -> this.content);
    }

    @Test
    public void testGetters() {
        Assert.assertEquals((Object)TreeItem.State.CLOSE, (Object)this.testedRoot.getState());
        Assert.assertEquals((Object)TreeItem.Type.ROOT, (Object)this.testedRoot.getType());
        Assert.assertEquals((Object)ROOT_LABEL, (Object)this.testedRoot.getLabel());
        Assert.assertEquals((Object)ROOT_VALUE, (Object)this.testedRoot.getUuid());
        Assert.assertEquals((Object)TreeItem.State.CLOSE, (Object)this.testedContainer.getState());
        Assert.assertEquals((Object)TreeItem.Type.CONTAINER, (Object)this.testedContainer.getType());
        Assert.assertEquals((Object)CONTAINER_LABEL, (Object)this.testedContainer.getLabel());
        Assert.assertEquals((Object)CONTAINER_VALUE, (Object)this.testedContainer.getUuid());
        Assert.assertEquals((Object)TreeItem.State.NONE, (Object)this.testedItem.getState());
        Assert.assertEquals((Object)TreeItem.Type.ITEM, (Object)this.testedItem.getType());
        Assert.assertEquals((Object)ITEM_LABEL, (Object)this.testedItem.getLabel());
        Assert.assertEquals((Object)ITEM_VALUE, (Object)this.testedItem.getUuid());
    }

    @Test
    public void testAddItem() {
        TreeItem childTreeItem = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)childTreeItem.getType()).thenReturn((Object)TreeItem.Type.ITEM);
        TreeItem treeItem1 = this.testedRoot.addItem(childTreeItem);
        Assert.assertEquals((Object)treeItem1, (Object)childTreeItem);
        ((TreeItem)Mockito.verify((Object)childTreeItem, (VerificationMode)Mockito.times((int)1))).setTree((Tree)Matchers.eq(this.tree));
        ((TreeItem)Mockito.verify((Object)childTreeItem, (VerificationMode)Mockito.times((int)1))).setParentItem((TreeItem)Matchers.eq((Object)this.testedRoot));
        ((FlowPanel)Mockito.verify((Object)this.content, (VerificationMode)Mockito.times((int)1))).add((Widget)Matchers.eq((Object)childTreeItem));
    }

    @Test
    public void testAddContainer() {
        TreeItem childTreeContainer = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)childTreeContainer.getType()).thenReturn((Object)TreeItem.Type.CONTAINER);
        TreeItem treeItem1 = this.testedRoot.addItem(childTreeContainer);
        Assert.assertEquals((Object)treeItem1, (Object)childTreeContainer);
        ((TreeItem)Mockito.verify((Object)childTreeContainer, (VerificationMode)Mockito.times((int)1))).setTree((Tree)Matchers.eq(this.tree));
        ((TreeItem)Mockito.verify((Object)childTreeContainer, (VerificationMode)Mockito.times((int)1))).setParentItem((TreeItem)Matchers.eq((Object)this.testedRoot));
        ((FlowPanel)Mockito.verify((Object)this.content, (VerificationMode)Mockito.times((int)1))).add((Widget)Matchers.eq((Object)childTreeContainer));
    }

    @Test
    public void testAddItemToContainer() {
        TreeItem childTreeContainer = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)childTreeContainer.getType()).thenReturn((Object)TreeItem.Type.CONTAINER);
        TreeItem childTreeItem = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)childTreeItem.getType()).thenReturn((Object)TreeItem.Type.ITEM);
        TreeItem treeItem1 = this.testedRoot.addItem(childTreeContainer);
        TreeItem treeItem2 = this.testedContainer.addItem(treeItem1);
        Assert.assertEquals((Object)treeItem1, (Object)childTreeContainer);
        Assert.assertEquals((Object)treeItem2, (Object)treeItem1);
        ((TreeItem)Mockito.verify((Object)childTreeContainer, (VerificationMode)Mockito.times((int)1))).setTree((Tree)Matchers.eq(this.tree));
        ((TreeItem)Mockito.verify((Object)childTreeContainer, (VerificationMode)Mockito.times((int)1))).setParentItem((TreeItem)Matchers.eq((Object)this.testedRoot));
        ((FlowPanel)Mockito.verify((Object)this.content, (VerificationMode)Mockito.times((int)2))).add((Widget)Matchers.eq((Object)treeItem2));
        ((TreeItem)Mockito.verify((Object)treeItem1, (VerificationMode)Mockito.times((int)1))).setTree((Tree)Matchers.eq(this.tree));
    }

    @Test
    public void testInsertItem() {
        TreeItem childTreeItem = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)childTreeItem.getType()).thenReturn((Object)TreeItem.Type.ITEM);
        int index = 7;
        TreeItem treeItem1 = this.testedRoot.insertItem(childTreeItem, 7);
        Assert.assertEquals((Object)treeItem1, (Object)childTreeItem);
        ((TreeItem)Mockito.verify((Object)childTreeItem, (VerificationMode)Mockito.times((int)1))).setTree((Tree)Matchers.eq(this.tree));
        ((TreeItem)Mockito.verify((Object)childTreeItem, (VerificationMode)Mockito.times((int)1))).setParentItem((TreeItem)Matchers.eq((Object)this.testedRoot));
        ((FlowPanel)Mockito.verify((Object)this.content, (VerificationMode)Mockito.times((int)1))).insert((Widget)Matchers.eq((Object)childTreeItem), Matchers.eq((int)7));
    }

    @Test
    public void testInsertContainer() {
        TreeItem childTreeContainer = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)childTreeContainer.getType()).thenReturn((Object)TreeItem.Type.CONTAINER);
        int index = 10;
        TreeItem treeItem1 = this.testedRoot.insertItem(childTreeContainer, 10);
        Assert.assertEquals((Object)treeItem1, (Object)childTreeContainer);
        ((TreeItem)Mockito.verify((Object)childTreeContainer, (VerificationMode)Mockito.times((int)1))).setTree((Tree)Matchers.eq(this.tree));
        ((TreeItem)Mockito.verify((Object)childTreeContainer, (VerificationMode)Mockito.times((int)1))).setParentItem((TreeItem)Matchers.eq((Object)this.testedRoot));
        ((FlowPanel)Mockito.verify((Object)this.content, (VerificationMode)Mockito.times((int)1))).insert((Widget)Matchers.eq((Object)childTreeContainer), Matchers.eq((int)10));
    }

    @Test
    public void testInsertItemToContainer() {
        TreeItem childTreeContainer = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)childTreeContainer.getType()).thenReturn((Object)TreeItem.Type.CONTAINER);
        TreeItem childTreeItem = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)childTreeItem.getType()).thenReturn((Object)TreeItem.Type.ITEM);
        int index1 = 17;
        int index2 = 25;
        TreeItem treeItem1 = this.testedRoot.insertItem(childTreeContainer, 17);
        TreeItem treeItem2 = this.testedContainer.insertItem(treeItem1, 25);
        Assert.assertEquals((Object)treeItem1, (Object)childTreeContainer);
        Assert.assertEquals((Object)treeItem2, (Object)treeItem1);
        ((TreeItem)Mockito.verify((Object)childTreeContainer, (VerificationMode)Mockito.times((int)1))).setTree((Tree)Matchers.eq(this.tree));
        ((TreeItem)Mockito.verify((Object)childTreeContainer, (VerificationMode)Mockito.times((int)1))).setParentItem((TreeItem)Matchers.eq((Object)this.testedRoot));
        ((FlowPanel)Mockito.verify((Object)this.content, (VerificationMode)Mockito.times((int)1))).insert((Widget)Matchers.eq((Object)treeItem2), Matchers.eq((int)17));
        ((FlowPanel)Mockito.verify((Object)this.content, (VerificationMode)Mockito.times((int)1))).insert((Widget)Matchers.eq((Object)treeItem2), Matchers.eq((int)25));
        ((TreeItem)Mockito.verify((Object)treeItem1, (VerificationMode)Mockito.times((int)1))).setTree((Tree)Matchers.eq(this.tree));
    }

    @Test
    public void testGetChildCount() {
        this.testedRoot.getChildCount();
        ((FlowPanel)Mockito.verify((Object)this.content, (VerificationMode)Mockito.times((int)1))).getWidgetCount();
    }

    @Test
    public void testRemoveItems() {
        this.testedRoot.removeItems();
        ((FlowPanel)Mockito.verify((Object)this.content, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testRemove() {
        Tree tree = new Tree(() -> this.treeContainer);
        this.testedRoot.setTree(tree);
        tree.addItem(this.testedRoot);
        this.testedRoot.remove();
        ((FlowPanel)Mockito.verify((Object)this.treeContainer, (VerificationMode)Mockito.times((int)1))).remove((Widget)Matchers.eq((Object)this.testedRoot));
    }

    @Test
    public void testRemoveItem() {
        TreeItem item = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)item.getType()).thenReturn((Object)TreeItem.Type.ITEM);
        this.testedRoot.addItem(item);
        this.testedRoot.removeItem(item);
        ((FlowPanel)Mockito.verify((Object)this.content, (VerificationMode)Mockito.times((int)1))).remove((Widget)Matchers.eq((Object)item));
    }

    @Test
    public void testRemoveItemFromParent() {
        TreeItem childTreeContainer = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)childTreeContainer.getType()).thenReturn((Object)TreeItem.Type.CONTAINER);
        TreeItem childTreeItem = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)childTreeItem.getType()).thenReturn((Object)TreeItem.Type.ITEM);
        this.testedRoot.addItem(childTreeContainer);
        this.testedRoot.removeItem(childTreeContainer);
        ((FlowPanel)Mockito.verify((Object)this.content, (VerificationMode)Mockito.times((int)1))).remove((Widget)Matchers.eq((Object)childTreeContainer));
    }

    @Test
    public void testGetItemByUuid() {
        TreeItem treeItemTest = this.testedRoot.getItemByUuid(ROOT_VALUE);
        Assert.assertEquals((Object)treeItemTest, (Object)this.testedRoot);
    }

    @Test
    public void testGetItemByUuidChildren() {
        TreeItem item = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)item.getItemByUuid(ITEM_VALUE)).thenReturn((Object)item);
        Mockito.when((Object)this.content.getWidgetCount()).thenReturn((Object)1);
        Mockito.when((Object)this.content.getWidget(Matchers.eq((int)0))).thenReturn((Object)item);
        TreeItem treeItemTest = this.testedRoot.getItemByUuid(ITEM_VALUE);
        Assert.assertEquals((Object)treeItemTest, (Object)item);
    }
}

