/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.editors.defaulteditor;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.Consumer;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.base.form.AbstractForm;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.common.FileUploadFormEncoder;
import org.uberfire.ext.widgets.core.client.editors.defaulteditor.DefaultEditorFileUploadBaseTestWrapper;

@RunWith(value=GwtMockitoTestRunner.class)
public class DefaultEditorFileUploadTest {
    @InjectMocks
    private DefaultEditorFileUploadBaseTestWrapper editor;
    @GwtMock
    private Form form;
    @Mock
    private FileUploadFormEncoder formEncoder;
    @Mock
    private Consumer<String> successCallback;
    @Mock
    private Consumer<String> errorCallback;

    @Before
    public void setup() {
        this.editor.forceInitForm();
    }

    @Test
    public void formCharsetAdded() {
        ((FileUploadFormEncoder)Mockito.verify((Object)this.formEncoder, (VerificationMode)Mockito.times((int)1))).addUtf8Charset(this.form);
    }

    @Test
    public void formSubmitHandlersSet() {
        ((Form)Mockito.verify((Object)this.form, (VerificationMode)Mockito.never())).addSubmitHandler((AbstractForm.SubmitHandler)Matchers.any(AbstractForm.SubmitHandler.class));
        ((Form)Mockito.verify((Object)this.form, (VerificationMode)Mockito.times((int)1))).addSubmitCompleteHandler((AbstractForm.SubmitCompleteHandler)Matchers.any(AbstractForm.SubmitCompleteHandler.class));
    }

    @Test
    public void formSubmitValidState() {
        this.editor.setValid(true);
        this.editor.upload(this.successCallback, this.errorCallback);
        ((Form)Mockito.verify((Object)this.form, (VerificationMode)Mockito.times((int)1))).submit();
    }

    @Test
    public void formSubmitInvalidState() {
        this.editor.setValid(false);
        this.editor.upload(this.successCallback, this.errorCallback);
        ((Form)Mockito.verify((Object)this.form, (VerificationMode)Mockito.never())).submit();
    }
}

