/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.organizationalunit.config;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.organizationalunit.config.RepositoryConfiguration;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class RepositoryInfo {
    private static final String CONTRIBUTORS = "contributors";
    private static final String SECURITY_GROUPS = "security:groups";
    private String name;
    private boolean deleted;
    private RepositoryConfiguration configuration;

    public RepositoryInfo(@MapsTo(value="name") String name, @MapsTo(value="deleted") boolean deleted, @MapsTo(value="configuration") RepositoryConfiguration configuration) {
        this.name = name;
        this.deleted = deleted;
        this.configuration = configuration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public List<Contributor> getContributors() {
        return this.configuration.get(List.class, CONTRIBUTORS, new ArrayList());
    }

    public String getScheme() {
        return this.configuration.get(String.class, "scheme", "");
    }

    public List<String> getSecurityGroups() {
        return this.configuration.get(List.class, SECURITY_GROUPS, new ArrayList());
    }

    public boolean isAvoidIndex() {
        return this.configuration.get(Boolean.class, "avoid_index", false);
    }

    public String getSpace() {
        return this.configuration.get(String.class, "space", "");
    }

    public RepositoryConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(RepositoryConfiguration configuration) {
        this.configuration = configuration;
    }
}

