/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.uberfire.ext.security.management.api.exception.EntityNotFoundException;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.api.exception.NoImplementationAvailableException;
import org.uberfire.ext.security.management.api.exception.RealmManagementNotAuthorizedException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.exception.UnsupportedServiceCapabilityException;
import org.uberfire.ext.security.management.api.exception.UserAlreadyExistsException;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementClientConstants;

@ApplicationScoped
public class ClientSecurityExceptionMessageResolver {
    private static final String ARG_SEPARATOR = ": ";
    private final Map<Class<?>, Function<SecurityManagementException, String>> messageResolvers = new HashMap(6);

    @PostConstruct
    public void registerMessageResolvers() {
        this.register(EntityNotFoundException.class, e -> ClientSecurityExceptionMessageResolver.getArgMessage(UsersManagementClientConstants.INSTANCE.entityNotFound(), e.getIdentifier()));
        this.register(UserNotFoundException.class, e -> ClientSecurityExceptionMessageResolver.getArgMessage(UsersManagementClientConstants.INSTANCE.userNotFound(), e.getIdentifier()));
        this.register(GroupNotFoundException.class, e -> ClientSecurityExceptionMessageResolver.getArgMessage(UsersManagementClientConstants.INSTANCE.groupNotFound(), e.getIdentifier()));
        this.register(NoImplementationAvailableException.class, e -> UsersManagementClientConstants.INSTANCE.noUserSystemManagerActive());
        this.register(UnsupportedServiceCapabilityException.class, e -> ClientSecurityExceptionMessageResolver.getArgMessage(UsersManagementClientConstants.INSTANCE.unsupportedCapability(), e.getCapability().name()));
        this.register(UserAlreadyExistsException.class, e -> ClientSecurityExceptionMessageResolver.getArgMessage(UsersManagementClientConstants.INSTANCE.userAlreadyExists(), e.getUserId()));
        this.register(RealmManagementNotAuthorizedException.class, e -> ClientSecurityExceptionMessageResolver.getArgMessage(UsersManagementClientConstants.INSTANCE.realmManagementNotAuthorized(), e.getRealmResource()));
    }

    public void consumeExceptionMessage(Throwable exception, Consumer<String> messageConsumer) {
        if (this.shouldDisplayError().test(exception)) {
            String message = this.isSecurityManagementException().test(exception) ? this.getSecurityExceptionMessage().apply((SecurityManagementException)exception) : this.getExceptionMessage().apply(exception);
            messageConsumer.accept(message);
        }
    }

    private Predicate<Throwable> shouldDisplayError() {
        return throwable -> !(throwable instanceof NoImplementationAvailableException);
    }

    private Predicate<Throwable> isSecurityManagementException() {
        return throwable -> throwable instanceof SecurityManagementException;
    }

    private Function<SecurityManagementException, String> getSecurityExceptionMessage() {
        return exception -> this.messageResolvers.getOrDefault(exception.getClass(), Throwable::getMessage).apply((SecurityManagementException)exception);
    }

    private Function<Throwable, String> getExceptionMessage() {
        return exception -> exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
    }

    private <E extends SecurityManagementException> void register(Class<E> type, Function<E, String> messageResolver) {
        this.messageResolvers.put(type, messageResolver);
    }

    private static String getArgMessage(String message, String arg) {
        return message + ARG_SEPARATOR + arg;
    }
}

