/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor;

import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Modal;
import org.uberfire.ext.layout.editor.api.css.CssProperty;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.client.api.HasModalConfiguration;
import org.uberfire.ext.layout.editor.client.api.ModalConfigurationContext;
import org.uberfire.ext.layout.editor.client.api.RenderingContext;
import org.uberfire.ext.layout.editor.client.infra.LayoutEditorCssHelper;
import org.uberfire.ext.plugin.client.perspective.editor.api.PerspectiveEditorCoreComponent;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups.EditHTMLPresenter;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;

@Dependent
public class HTMLLayoutDragComponent
implements PerspectiveEditorCoreComponent,
HasModalConfiguration {
    public static final String HTML_CODE_PARAMETER = "HTML_CODE";
    @Inject
    private LayoutEditorCssHelper layoutCssHelper;
    @Inject
    private EditHTMLPresenter htmlEditor;

    public String getDragComponentTitle() {
        return CommonConstants.INSTANCE.HTMLComponent();
    }

    public String getDragComponentIconClass() {
        return "fa fa-html5";
    }

    public List<PropertyEditorCategory> getPropertyCategories(LayoutComponent layoutComponent) {
        Map propertyMap = layoutComponent.getProperties();
        ArrayList<PropertyEditorCategory> result = new ArrayList<PropertyEditorCategory>();
        PropertyEditorCategory category = this.layoutCssHelper.createCategory("text");
        category.withField(this.layoutCssHelper.createField(propertyMap, CssProperty.TEXT_ALIGN));
        category.withField(this.layoutCssHelper.createField(propertyMap, CssProperty.TEXT_DECORATION));
        category.withField(this.layoutCssHelper.createField(propertyMap, CssProperty.COLOR));
        category.withField(this.layoutCssHelper.createField(propertyMap, CssProperty.FONT_SIZE));
        category.withField(this.layoutCssHelper.createField(propertyMap, CssProperty.FONT_WEIGHT));
        result.add(category);
        return result;
    }

    public IsWidget getPreviewWidget(RenderingContext container) {
        return this.getShowWidget(container);
    }

    public IsWidget getShowWidget(RenderingContext context) {
        Map properties = context.getComponent().getProperties();
        String html = (String)properties.get(HTML_CODE_PARAMETER);
        if (html == null) {
            return null;
        }
        return new HTMLPanel(html);
    }

    public Modal getConfigurationModal(ModalConfigurationContext ctx) {
        this.htmlEditor.init(ctx);
        return this.htmlEditor.getView().getModal();
    }
}

