/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.widget.popup;

import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.plugin.client.validation.PluginNameValidator;
import org.uberfire.ext.plugin.client.widget.popup.NewPluginPopUp;
import org.uberfire.ext.plugin.client.widget.popup.NewPluginPopUpView;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class NewPluginPopUpTest {
    private PluginNameValidator successValidator;
    private PluginNameValidator failureValidator;
    @Mock
    private NewPluginPopUpView view;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private PluginServices pluginServices;
    private Caller<PluginServices> pluginServicesCaller;
    @Mock
    private Plugin plugin;
    @Mock
    private PathPlaceRequest pathPlaceRequest;
    private NewPluginPopUp presenter;

    @Before
    public void setUp() {
        this.presenter = new NewPluginPopUp(this.view){

            protected PlaceRequest getPathPlaceRequest(Plugin response) {
                return new PathPlaceRequest();
            }
        };
        this.pluginServicesCaller = new CallerMock((Object)this.pluginServices);
        this.presenter.pluginServices = this.pluginServicesCaller;
        this.presenter.placeManager = this.placeManager;
        Mockito.when((Object)this.pluginServices.createNewPlugin(Mockito.anyString(), (PluginType)Mockito.any(PluginType.class))).thenReturn((Object)new Plugin());
        this.successValidator = (PluginNameValidator)Mockito.spy((Object)new PluginNameValidator(){

            public void validate(String value, ValidatorCallback callback) {
                callback.onSuccess();
            }
        });
        this.failureValidator = (PluginNameValidator)Mockito.spy((Object)new PluginNameValidator(){

            public void validate(String value, ValidatorCallback callback) {
                callback.onFailure();
            }
        });
    }

    @Test
    public void testSuccessfulValidation() {
        this.presenter.pluginNameValidator = this.successValidator;
        this.presenter.onOK("newPlugin", PluginType.PERSPECTIVE);
        ((PluginNameValidator)Mockito.verify((Object)this.successValidator)).validate((String)Mockito.eq((Object)"newPlugin.plugin"), (ValidatorCallback)Mockito.any(ValidatorCallback.class));
        ((PluginServices)Mockito.verify((Object)this.pluginServices)).createNewPlugin("newPlugin", PluginType.PERSPECTIVE);
    }

    @Test
    public void testFailedValidation() {
        this.presenter.pluginNameValidator = this.failureValidator;
        this.presenter.onOK("invalid*", PluginType.PERSPECTIVE);
        ((PluginNameValidator)Mockito.verify((Object)this.failureValidator)).validate((String)Mockito.eq((Object)"invalid*.plugin"), (ValidatorCallback)Mockito.any(ValidatorCallback.class));
        ((NewPluginPopUpView)Mockito.verify((Object)this.view)).handleNameValidationError(Mockito.anyString());
        ((NewPluginPopUpView)Mockito.verify((Object)this.view)).invalidName();
        ((PluginServices)Mockito.verify((Object)this.pluginServices, (VerificationMode)Mockito.never())).createNewPlugin(Mockito.anyString(), (PluginType)Mockito.any(PluginType.class));
    }

    @Test
    public void testPopupCanceled() {
        this.presenter.onCancel();
        ((PluginNameValidator)Mockito.verify((Object)this.successValidator, (VerificationMode)Mockito.never())).validate(Mockito.anyString(), (ValidatorCallback)Mockito.any(ValidatorCallback.class));
        ((PluginNameValidator)Mockito.verify((Object)this.failureValidator, (VerificationMode)Mockito.never())).validate(Mockito.anyString(), (ValidatorCallback)Mockito.any(ValidatorCallback.class));
        ((PluginServices)Mockito.verify((Object)this.pluginServices, (VerificationMode)Mockito.never())).createNewPlugin(Mockito.anyString(), (PluginType)Mockito.any(PluginType.class));
        ((NewPluginPopUpView)Mockito.verify((Object)this.view)).hide();
    }
}

