/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.lang.reflect.Method;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.junit.Assert;
import org.junit.Test;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;

public class PermissionsTest {
    private static Reflections reflections = new Reflections(new Object[]{ClasspathHelper.forPackage((String)"org.kie.remote.services.rest", (ClassLoader[])new ClassLoader[0]), new TypeAnnotationsScanner(), new MethodAnnotationsScanner(), new SubTypesScanner()});

    @Test
    public void allRestMethodsHaveRolesAssigned() {
        Set restMethods = reflections.getMethodsAnnotatedWith(Path.class);
        restMethods.addAll(reflections.getMethodsAnnotatedWith(GET.class));
        restMethods.addAll(reflections.getMethodsAnnotatedWith(POST.class));
        restMethods.addAll(reflections.getMethodsAnnotatedWith(DELETE.class));
        restMethods.addAll(reflections.getMethodsAnnotatedWith(PUT.class));
        for (Method pathMethod : restMethods) {
            RolesAllowed rolesAllowedAnno = pathMethod.getAnnotation(RolesAllowed.class);
            Assert.assertNotNull((String)(pathMethod.getDeclaringClass() + "." + pathMethod.getName() + "(...) is missing a @RolesAllowed annotation!"), (Object)rolesAllowedAnno);
            boolean basicRestRoleFound = false;
            for (String role : rolesAllowedAnno.value()) {
                if (!"rest-all".equals(role)) continue;
                basicRestRoleFound = true;
                break;
            }
            Assert.assertTrue((String)(pathMethod.getDeclaringClass() + "." + pathMethod.getName() + "(...) is does not have the " + "rest-all" + " role"), (boolean)basicRestRoleFound);
        }
    }
}

