/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.rest.backend.PermissionAction;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.security.RepositoryAction;
import org.kie.soup.commons.util.Maps;
import org.uberfire.annotations.Customizable;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.AppFormerActivities;

@ApplicationScoped
public class ResourceTypePermissionValidator {
    private OrganizationalUnitService organizationalUnitService;
    private WorkspaceProjectService projectService;
    private AppFormerActivities appFormerActivities;
    private PermissionManager permissionManager;
    private Map<ResourceType, List<PermissionAction>> permissionMap = new Maps.Builder().put((Object)OrganizationalUnit.RESOURCE_TYPE, Arrays.asList(new PermissionAction(ResourceAction.READ), new PermissionAction((ResourceAction)RepositoryAction.CREATE), new PermissionAction((ResourceAction)RepositoryAction.UPDATE, ResourceAction.READ), new PermissionAction((ResourceAction)RepositoryAction.DELETE, ResourceAction.READ))).put((Object)Repository.RESOURCE_TYPE, Arrays.asList(new PermissionAction(ResourceAction.READ), new PermissionAction((ResourceAction)RepositoryAction.CREATE), new PermissionAction((ResourceAction)RepositoryAction.UPDATE, ResourceAction.READ), new PermissionAction((ResourceAction)RepositoryAction.DELETE, ResourceAction.READ), new PermissionAction((ResourceAction)RepositoryAction.BUILD, ResourceAction.READ))).put((Object)ActivityResourceType.PERSPECTIVE, Arrays.asList(new PermissionAction(ResourceAction.READ), new PermissionAction((ResourceAction)RepositoryAction.UPDATE, ResourceAction.READ), new PermissionAction((ResourceAction)RepositoryAction.DELETE, ResourceAction.READ), new PermissionAction((ResourceAction)RepositoryAction.CREATE, ResourceAction.READ))).put((Object)ActivityResourceType.EDITOR, Arrays.asList(new PermissionAction(ResourceAction.READ))).build();

    public ResourceTypePermissionValidator() {
    }

    @Inject
    public ResourceTypePermissionValidator(@Customizable AppFormerActivities appFormerActivities, OrganizationalUnitService organizationalUnitService, WorkspaceProjectService projectService, PermissionManager permissionManager) {
        this.appFormerActivities = appFormerActivities;
        this.organizationalUnitService = organizationalUnitService;
        this.projectService = projectService;
        this.permissionManager = permissionManager;
    }

    public Set<Map.Entry<ResourceType, List<PermissionAction>>> getPermissionEntries() {
        return this.permissionMap.entrySet();
    }

    public boolean isPermissionAllowed(ResourceType resourceType, ResourceAction permissionType) {
        return this.permissionMap.get(resourceType).stream().anyMatch(vp -> vp.getResourceAction().equals(permissionType));
    }

    public Optional<PermissionAction> resourceDependancy(ResourceType resourceType, ResourceAction permissionType) {
        return this.permissionMap.get(resourceType).stream().filter(vp -> vp.getResourceAction().equals(permissionType)).findFirst();
    }

    public boolean satisfyDependancies(PermissionCollection pc, ResourceType resourceType, ResourceAction resourceAction) {
        return this.resourceDependancy(resourceType, resourceAction).map(permissionAction -> {
            ResourceAction dependantAction = permissionAction.getDependantAction();
            if (dependantAction != null) {
                Permission permission = this.permissionManager.createPermission(resourceType, dependantAction, true);
                return pc.implies(permission);
            }
            return true;
        }).orElse(true);
    }

    public boolean isValidResourceType(ResourceType resourceType, String resourceId) {
        if (resourceType.equals(ActivityResourceType.PERSPECTIVE) && this.appFormerActivities.getAllPerpectivesIds().contains(resourceId)) {
            return true;
        }
        if (resourceType.equals(ActivityResourceType.EDITOR) && this.appFormerActivities.getAllEditorIds().contains(resourceId)) {
            return true;
        }
        if (resourceType.equals(OrganizationalUnit.RESOURCE_TYPE)) {
            return this.organizationalUnitService.getOrganizationalUnits().stream().anyMatch(orgUnit -> resourceId.equals(orgUnit.getName()));
        }
        if (resourceType.equals(Repository.RESOURCE_TYPE)) {
            return this.projectService.getAllWorkspaceProjects().stream().anyMatch(project -> resourceId.equals(project.getName()));
        }
        return false;
    }
}

