/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URL;
import java.util.List;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.POMServiceImpl;
import org.guvnor.common.services.project.backend.server.PomEnhancer;
import org.guvnor.common.services.project.backend.server.utils.POMContentHandler;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.m2repo.service.M2RepoService;
import org.guvnor.test.WeldJUnitRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=WeldJUnitRunner.class)
public class POMServiceImplLoadTest {
    @Inject
    @Named(value="ioStrategy")
    IOService ioService;
    @Inject
    POMContentHandler pomContentHandler;
    @Mock
    M2RepoService m2RepoService;
    @Mock
    MetadataService metadataService;
    @Mock
    PomEnhancer pomEnhancer;
    private POMService service;
    private IOService ioServiceSpy;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.ioServiceSpy = (IOService)Mockito.spy((Object)this.ioService);
        this.service = new POMServiceImpl(this.ioServiceSpy, this.pomContentHandler, this.m2RepoService, this.metadataService, (Event)new EventSourceMock(), (ModuleService)Mockito.mock(ModuleService.class), (CommentedOptionFactory)Mockito.mock(CommentedOptionFactory.class), this.pomEnhancer);
    }

    @Test
    public void testLoad() throws Exception {
        URL url = this.getClass().getResource("/TestProject/pom.xml");
        Path path = this.ioService.get(url.toURI());
        POM pom = (POM)this.service.load(Paths.convert((Path)path));
        Assert.assertEquals((Object)"org.test", (Object)pom.getGav().getGroupId());
        Assert.assertEquals((Object)"my-test", (Object)pom.getGav().getArtifactId());
        Assert.assertEquals((Object)"1.0", (Object)pom.getGav().getVersion());
        Assert.assertEquals((long)2L, (long)pom.getDependencies().size());
        this.assertContainsDependency("org.apache.commons", "commons-lang3", "compile", (List<Dependency>)pom.getDependencies());
        this.assertContainsDependency("org.jboss.weld", "weld-core-impl", "test", (List<Dependency>)pom.getDependencies());
    }

    private void assertContainsDependency(String groupID, String artifactID, String scope, List<Dependency> dependencies) {
        boolean foundOne = false;
        for (Dependency dependency : dependencies) {
            if (!groupID.equals(dependency.getGroupId()) || !artifactID.equals(dependency.getArtifactId()) || !scope.equals(dependency.getScope()) && (!scope.equals("compile") || dependency.getScope() != null)) continue;
            foundOne = true;
        }
        Assert.assertTrue((String)("Did not find dependency: " + groupID + ":" + artifactID + ":" + scope), (boolean)foundOne);
    }
}

