/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URISyntaxException;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.backend.server.ModuleFinder;
import org.guvnor.common.services.project.backend.server.ResourceResolver;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.test.WeldJUnitRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.NotImplementedException;
import org.uberfire.java.nio.file.Path;

@RunWith(value=WeldJUnitRunner.class)
public class ModuleFinderTest {
    @Inject
    @Named(value="ioStrategy")
    IOService ioService;
    @Inject
    POMService pomService;
    private ModuleFinder finder;

    @Before
    public void setUp() throws Exception {
        this.finder = new ModuleFinder(this.ioService, this.pomService);
    }

    private ResourceResolver getResourceResolver() throws URISyntaxException {
        final Path project1FolderPath = this.ioService.get(this.getClass().getResource("/LegacyRepositoryStructure/Project1/").toURI());
        final Path project1FilePath = this.ioService.get(this.getClass().getResource("/LegacyRepositoryStructure/Project1/pom.xml").toURI());
        final Path project2FolderPath = this.ioService.get(this.getClass().getResource("/LegacyRepositoryStructure/Project2/").toURI());
        final Path project2FilePath = this.ioService.get(this.getClass().getResource("/LegacyRepositoryStructure/Project2/pom.xml").toURI());
        return new ResourceResolver(){

            public Module resolveModule(org.uberfire.backend.vfs.Path resource, boolean loadPOM) {
                String uri = resource.toURI();
                if (uri.endsWith("Project1/pom.xml")) {
                    return new Module(Paths.convert((Path)project1FolderPath), Paths.convert((Path)project1FilePath), new POM(new GAV("test", "project1", "1.0")));
                }
                if (uri.endsWith("Project2/pom.xml")) {
                    return new Module(Paths.convert((Path)project2FolderPath), Paths.convert((Path)project2FilePath), new POM(new GAV("test", "project2", "1.0")));
                }
                return null;
            }

            public Module simpleModuleInstance(Path nioModuleRootPath) {
                throw new NotImplementedException();
            }
        };
    }

    @Test
    public void pomIsInPathRoot() throws Exception {
        Path folderPath = this.ioService.get(this.getClass().getResource("/LegacyRepositoryStructure/Project1/").toURI());
        Set modules = this.finder.find(this.getResourceResolver(), new Branch("master", Paths.convert((Path)folderPath)));
        Assert.assertFalse((boolean)modules.isEmpty());
    }

    @Test
    public void modulesAreInFolders() throws Exception {
        Path folderPath = this.ioService.get(this.getClass().getResource("/LegacyRepositoryStructure/").toURI());
        Set modules = this.finder.find(this.getResourceResolver(), new Branch("master", Paths.convert((Path)folderPath)));
        Assert.assertEquals((long)2L, (long)modules.size());
    }
}

