/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server.utils;

import org.guvnor.common.services.project.backend.server.utils.PathUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PathUtilTest {
    private PathUtil pathUtil;

    @Before
    public void setup() {
        this.pathUtil = new PathUtil();
    }

    @Test
    public void stripGitProtocolAndBranch() throws Exception {
        String result = this.pathUtil.stripProtocolAndBranch("git://master@space/repo/some/path");
        Assert.assertEquals((Object)"space/repo/some/path", (Object)result);
    }

    @Test
    public void stripDefaultProtocolAndBranch() throws Exception {
        String result = this.pathUtil.stripProtocolAndBranch("default://master@space/repo/some/path");
        Assert.assertEquals((Object)"space/repo/some/path", (Object)result);
    }

    @Test
    public void stripProtocolMissingBranch() throws Exception {
        String result = this.pathUtil.stripProtocolAndBranch("default://space/repo/some/path");
        Assert.assertEquals((Object)"space/repo/some/path", (Object)result);
    }

    @Test
    public void stripRepoNameAndSpace() throws Exception {
        String result = this.pathUtil.stripRepoNameAndSpace("space/repo/some/path");
        Assert.assertEquals((Object)"some/path", (Object)result);
    }

    @Test
    public void replaceBranchName() {
        String newUri = this.pathUtil.replaceBranch("new-branch", "git://current-branch@space/repo/some/path");
        Assert.assertEquals((Object)"git://new-branch@space/repo/some/path", (Object)newUri);
    }

    @Test
    public void replaceMissingBranchName() {
        String newUri = this.pathUtil.replaceBranch("new-branch", "git://space/repo/some/path");
        Assert.assertEquals((Object)"git://space/repo/some/path", (Object)newUri);
    }

    @Test
    public void replaceBranchNameWith$() {
        String newUri = this.pathUtil.replaceBranch("new$branch", "git://current-branch@space/repo/some/path");
        Assert.assertEquals((Object)"git://new$branch@space/repo/some/path", (Object)newUri);
    }
}

