/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.backend.server.utils.PathUtil;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.project.WorkspaceProjectMigrationService;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.uberfire.java.nio.file.Path;

public class WorkspaceProjectMigrationServiceImpl
implements WorkspaceProjectMigrationService {
    private WorkspaceProjectService workspaceProjectService;
    private RepositoryService repositoryService;
    private Event<NewProjectEvent> newProjectEvent;
    private ModuleService<? extends Module> moduleService;
    private PathUtil pathUtil;

    public WorkspaceProjectMigrationServiceImpl() {
    }

    @Inject
    public WorkspaceProjectMigrationServiceImpl(WorkspaceProjectService workspaceProjectService, RepositoryService repositoryService, OrganizationalUnitService organizationalUnitService, PathUtil pathUtil, Event<NewProjectEvent> newProjectEvent, ModuleService<? extends Module> moduleService) {
        this.workspaceProjectService = workspaceProjectService;
        this.repositoryService = repositoryService;
        this.pathUtil = pathUtil;
        this.newProjectEvent = newProjectEvent;
        this.moduleService = moduleService;
    }

    public void migrate(WorkspaceProject legacyWorkspaceProject) {
        Collection<Repository> newRepositories = this.copyModulesToRepositories(legacyWorkspaceProject);
        this.fireNewProjectEvents(newRepositories);
    }

    private void fireNewProjectEvents(Collection<Repository> newRepositories) {
        for (Repository repository : newRepositories) {
            WorkspaceProject newWorkspaceProject = this.workspaceProjectService.resolveProject(repository);
            this.newProjectEvent.fire((Object)new NewProjectEvent(newWorkspaceProject));
        }
    }

    private Collection<Repository> copyModulesToRepositories(WorkspaceProject legacyWorkspaceProject) {
        OrganizationalUnit ou = legacyWorkspaceProject.getOrganizationalUnit();
        Repository legacyRepository = legacyWorkspaceProject.getRepository();
        Map<Partition, List<Module>> modulesByDirectory = this.getModulesByRootDirAndSpace(ou, legacyRepository);
        return modulesByDirectory.entrySet().stream().map(entry -> this.createSubdirectoryCloneRepository(ou, legacyRepository, (Map.Entry<Partition, List<Module>>)entry)).collect(Collectors.toList());
    }

    private Repository createSubdirectoryCloneRepository(OrganizationalUnit ou, Repository legacyRepository, Map.Entry<Partition, List<Module>> entry) {
        Partition partition = entry.getKey();
        List<Module> modules = entry.getValue();
        String alias = modules.stream().map(module -> module.getModuleName()).findFirst().orElse("migratedproject");
        RepositoryEnvironmentConfigurations configurations = this.subdirectoryCloneConfiguration(legacyRepository, partition, modules);
        return this.repositoryService.createRepository(ou, GitRepository.SCHEME.toString(), alias, configurations);
    }

    private RepositoryEnvironmentConfigurations subdirectoryCloneConfiguration(Repository legacyRepository, Partition root, List<Module> modules) {
        RepositoryEnvironmentConfigurations configurations = new RepositoryEnvironmentConfigurations();
        configurations.setInit(false);
        configurations.setOrigin(this.getNiogitRepoPath(legacyRepository));
        String rootWithoutRepoAndSpace = root.branchlessPath.replaceFirst("^[^/]+/[^/]+/", "");
        configurations.setSubdirectory(rootWithoutRepoAndSpace);
        configurations.setMirror(false);
        List<String> branches = this.existingBranchesOf(modules);
        configurations.setBranches(branches);
        return configurations;
    }

    private List<String> existingBranchesOf(List<Module> modules) {
        List<String> branches = modules.stream().flatMap(module -> {
            Optional<String> oBranch = WorkspaceProjectMigrationServiceImpl.getBranchName(this.pathUtil.convert(module.getRootPath()));
            if (oBranch.isPresent()) {
                return Stream.of(oBranch.get());
            }
            return Stream.empty();
        }).collect(Collectors.toList());
        return branches;
    }

    private Map<Partition, List<Module>> getModulesByRootDirAndSpace(OrganizationalUnit ou, Repository legacyRepository) {
        HashMap<Partition, List<Module>> modulesByDirectory = new HashMap<Partition, List<Module>>();
        legacyRepository.getBranches().stream().flatMap(branch -> this.moduleService.getAllModules(branch).stream()).forEach(module -> {
            String fullURI = this.pathUtil.normalizePath(module.getRootPath()).toURI();
            String branchlessPath = fullURI.replaceFirst("^[A-Za-z]+://([^@]+@)?", "");
            Partition partition = new Partition(branchlessPath, ou);
            List modules = modulesByDirectory.computeIfAbsent(partition, ignore -> new ArrayList());
            modules.add(module);
        });
        return modulesByDirectory;
    }

    private static Optional<String> getBranchName(Path path) {
        String uri = path.toUri().toString();
        Matcher matcher = Pattern.compile("^[A-Za-z]+://([^@]+)@.*").matcher(uri);
        if (matcher.matches()) {
            return Optional.ofNullable(matcher.group(1));
        }
        return Optional.empty();
    }

    private String getNiogitRepoPath(Repository repository) {
        Branch branch = (Branch)repository.getDefaultBranch().get();
        Path path = this.pathUtil.convert(branch.getPath());
        return this.pathUtil.getNiogitRepoPath(path);
    }

    private static class Partition {
        final String branchlessPath;
        final OrganizationalUnit ou;

        Partition(String branchlessPath, OrganizationalUnit ou) {
            this.branchlessPath = branchlessPath;
            this.ou = ou;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.branchlessPath == null ? 0 : this.branchlessPath.hashCode());
            result = 31 * result + (this.ou == null ? 0 : this.ou.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Partition other = (Partition)obj;
            if (this.branchlessPath == null ? other.branchlessPath != null : !this.branchlessPath.equals(other.branchlessPath)) {
                return false;
            }
            return !(this.ou == null ? other.ou != null : !this.ou.equals(other.ou));
        }
    }
}

