/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import org.guvnor.common.services.project.backend.server.utils.POMContentHandler;
import org.guvnor.common.services.project.model.POM;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class POMContentHandlerOneToOneTest {
    private String fileName;

    @Test
    public void testNoChanges() throws Exception {
        String pomxml = POMContentHandlerOneToOneTest.fromStream(POMContentHandlerOneToOneTest.class.getResourceAsStream(this.fileName));
        POM model = new POMContentHandler().toModel(pomxml);
        this.assertContainsIgnoreWhitespace(pomxml, new POMContentHandler().toString(model, pomxml));
    }

    public POMContentHandlerOneToOneTest(String fileName) {
        this.fileName = fileName;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getData() {
        return Arrays.asList({"pom1.xml"}, {"pom2.xml"}, {"pom3.xml"});
    }

    public static String fromStream(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder out = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            out.append(line).append("\n");
        }
        return out.toString();
    }

    private void assertContainsIgnoreWhitespace(String expected, String xml) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = xml.replaceAll("\\s+", "");
        Assert.assertEquals((String)("Failure with pom file: " + this.fileName), (Object)cleanExpected, (Object)cleanActual);
    }
}

