/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.project.WorkspaceProjectMigrationService;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryCopier;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

public class WorkspaceProjectMigrationServiceImpl
implements WorkspaceProjectMigrationService {
    private WorkspaceProjectService workspaceProjectService;
    private RepositoryService repositoryService;
    private Event<NewProjectEvent> newProjectEvent;
    private RepositoryCopier repositoryCopier;
    private ModuleService<? extends Module> moduleService;
    private IOService ioService;

    public WorkspaceProjectMigrationServiceImpl() {
    }

    @Inject
    public WorkspaceProjectMigrationServiceImpl(WorkspaceProjectService workspaceProjectService, RepositoryService repositoryService, OrganizationalUnitService organizationalUnitService, Event<NewProjectEvent> newProjectEvent, RepositoryCopier repositoryCopier, ModuleService<? extends Module> moduleService, @Named(value="ioStrategy") IOService ioService) {
        this.workspaceProjectService = workspaceProjectService;
        this.repositoryService = repositoryService;
        this.newProjectEvent = newProjectEvent;
        this.repositoryCopier = repositoryCopier;
        this.moduleService = moduleService;
        this.ioService = ioService;
    }

    public void migrate(WorkspaceProject legacyWorkspaceProject) {
        new Migrator(legacyWorkspaceProject).migrate();
    }

    private class Migrator {
        private final WorkspaceProject legacyWorkspaceProject;
        private final Map<String, Repository> newRepositories = new HashMap<String, Repository>();

        public Migrator(WorkspaceProject legacyWorkspaceProject) {
            this.legacyWorkspaceProject = legacyWorkspaceProject;
        }

        public void migrate() {
            this.copyModulesToRepositories();
            this.fireNewProjectEvents();
        }

        private void fireNewProjectEvents() {
            for (Repository repository : this.newRepositories.values()) {
                WorkspaceProject newWorkspaceProject = WorkspaceProjectMigrationServiceImpl.this.workspaceProjectService.resolveProject(repository);
                WorkspaceProjectMigrationServiceImpl.this.newProjectEvent.fire((Object)new NewProjectEvent(newWorkspaceProject));
            }
        }

        private void copyModulesToRepositories() {
            for (Branch branch : this.legacyWorkspaceProject.getRepository().getBranches()) {
                for (Module module : WorkspaceProjectMigrationServiceImpl.this.moduleService.getAllModules(branch)) {
                    if (!this.newRepositories.containsKey(module.getModuleName())) {
                        this.createRepository(module);
                    }
                    this.copyFromLegacyRepositoryToTheNew(branch, module);
                }
            }
        }

        private void copyFromLegacyRepositoryToTheNew(Branch branch, Module module) {
            Repository targetRepository = this.newRepositories.get(module.getModuleName());
            URI uri = URI.create(targetRepository.getScheme().toString() + "://" + branch.getName() + "@" + targetRepository.getSpace() + "/" + targetRepository.getAlias());
            Path targetBranchRoot = WorkspaceProjectMigrationServiceImpl.this.ioService.get(uri);
            WorkspaceProjectMigrationServiceImpl.this.repositoryCopier.copy(targetRepository.getSpace(), module.getRootPath(), Paths.convert((Path)targetBranchRoot));
        }

        private void createRepository(Module module) {
            RepositoryEnvironmentConfigurations configurations = new RepositoryEnvironmentConfigurations();
            configurations.setSpace(this.legacyWorkspaceProject.getOrganizationalUnit().getSpace().getName());
            Repository repository = WorkspaceProjectMigrationServiceImpl.this.repositoryService.createRepository(this.legacyWorkspaceProject.getOrganizationalUnit(), GitRepository.SCHEME.toString(), WorkspaceProjectMigrationServiceImpl.this.repositoryCopier.makeSafeRepositoryName(module.getModuleName()), configurations);
            this.newRepositories.put(module.getModuleName(), repository);
        }
    }
}

