/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.guvnor.common.services.project.backend.server.WorkspaceProjectMigrationServiceImpl;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryCopier;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspaceProjectMigrationServiceImplTest {
    private WorkspaceProjectMigrationServiceImpl service;
    @Mock
    private ModuleService moduleService;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private EventSourceMock<NewProjectEvent> newProjectEvent;
    @Mock
    private IOService ioService;
    @Mock
    private RepositoryCopier repositoryCopier;
    @Mock
    private org.uberfire.backend.vfs.Path legacyMasterBranchProject1RootPath;
    @Mock
    private org.uberfire.backend.vfs.Path legacyDevBranchProject1RootPath;
    @Mock
    private org.uberfire.backend.vfs.Path legacyDevBranchProject2RootPath;
    @Mock
    private OrganizationalUnitService organizationalUnitService;
    @Mock
    private OrganizationalUnit organizationalUnit;
    @Mock
    private WorkspaceProjectService workspaceProjectService;
    @Mock
    private Space space;
    @Captor
    private ArgumentCaptor<org.uberfire.backend.vfs.Path> pathArgumentCaptor;
    @Captor
    private ArgumentCaptor<NewProjectEvent> newProjectEventArgumentCaptor;
    private Branch legacyMasterBranch;
    private Branch legacyDevBranch;

    @Before
    public void setUp() throws Exception {
        ((WorkspaceProjectService)Mockito.doReturn((Object)Mockito.mock(WorkspaceProject.class)).when((Object)this.workspaceProjectService)).resolveProject((Repository)Mockito.any(Repository.class));
        ((IOService)Mockito.doAnswer((Answer)new Answer<Path>(){

            public Path answer(InvocationOnMock invocationOnMock) throws Throwable {
                return Paths.convert((org.uberfire.backend.vfs.Path)PathFactory.newPath((String)"file", (String)invocationOnMock.getArguments()[0].toString()));
            }
        }).when((Object)this.ioService)).get((URI)Mockito.any(URI.class));
        this.service = new WorkspaceProjectMigrationServiceImpl(this.workspaceProjectService, this.repositoryService, this.organizationalUnitService, this.newProjectEvent, this.repositoryCopier, this.moduleService, this.ioService);
        Mockito.when((Object)this.repositoryCopier.makeSafeRepositoryName(Mockito.anyString())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocationOnMock) throws Throwable {
                return (String)invocationOnMock.getArguments()[0];
            }
        });
        this.legacyMasterBranch = this.mockBranch("legacyMasterBranch");
        this.legacyDevBranch = this.mockBranch("legacyDevBranch");
        Repository legacyRepository = this.mockLegacyRepository();
        ((OrganizationalUnit)Mockito.doReturn((Object)new Space("space")).when((Object)this.organizationalUnit)).getSpace();
        WorkspaceProject legacyWorkspaceProject = new WorkspaceProject(this.organizationalUnit, legacyRepository, this.legacyMasterBranch, null);
        this.setUpMasterBranch();
        this.setUpDevBranch();
        this.mockRepository(this.organizationalUnit);
        this.service.migrate(legacyWorkspaceProject);
    }

    @Test
    public void createOnlyTwoRepositories() throws Exception {
        ((RepositoryService)Mockito.verify((Object)this.repositoryService, (VerificationMode)Mockito.times((int)2))).createRepository((OrganizationalUnit)Mockito.any(OrganizationalUnit.class), Mockito.anyString(), Mockito.anyString(), (RepositoryEnvironmentConfigurations)Mockito.any(RepositoryEnvironmentConfigurations.class));
    }

    @Test
    public void copy() throws Exception {
        ((RepositoryCopier)Mockito.verify((Object)this.repositoryCopier)).copy((Space)Mockito.eq((Object)this.space), (org.uberfire.backend.vfs.Path)Mockito.eq((Object)this.legacyMasterBranchProject1RootPath), (org.uberfire.backend.vfs.Path)this.pathArgumentCaptor.capture());
        ((RepositoryCopier)Mockito.verify((Object)this.repositoryCopier)).copy((Space)Mockito.eq((Object)this.space), (org.uberfire.backend.vfs.Path)Mockito.eq((Object)this.legacyDevBranchProject1RootPath), (org.uberfire.backend.vfs.Path)this.pathArgumentCaptor.capture());
        ((RepositoryCopier)Mockito.verify((Object)this.repositoryCopier)).copy((Space)Mockito.eq((Object)this.space), (org.uberfire.backend.vfs.Path)Mockito.eq((Object)this.legacyDevBranchProject2RootPath), (org.uberfire.backend.vfs.Path)this.pathArgumentCaptor.capture());
        List allValues = this.pathArgumentCaptor.getAllValues();
        Assert.assertEquals((long)3L, (long)allValues.size());
        Assert.assertNotNull(allValues.get(0));
        Assert.assertNotNull(allValues.get(1));
        Assert.assertNotNull(allValues.get(2));
    }

    @Test
    public void fireNewProjectEvents() throws Exception {
        ((EventSourceMock)Mockito.verify(this.newProjectEvent, (VerificationMode)Mockito.times((int)2))).fire(this.newProjectEventArgumentCaptor.capture());
        List allValues = this.newProjectEventArgumentCaptor.getAllValues();
        Assert.assertNotNull((Object)((NewProjectEvent)allValues.get(0)).getWorkspaceProject());
        Assert.assertNotNull((Object)((NewProjectEvent)allValues.get(1)).getWorkspaceProject());
    }

    private void setUpDevBranch() {
        HashSet<Module> devBranchModules = new HashSet<Module>();
        devBranchModules.add(this.mockModule("legacyProject1", this.legacyDevBranchProject1RootPath));
        devBranchModules.add(this.mockModule("legacyProject2", this.legacyDevBranchProject2RootPath));
        ((ModuleService)Mockito.doReturn(devBranchModules).when((Object)this.moduleService)).getAllModules(this.legacyDevBranch);
    }

    private void setUpMasterBranch() {
        HashSet<Module> masterBranchModules = new HashSet<Module>();
        masterBranchModules.add(this.mockModule("legacyProject1", this.legacyMasterBranchProject1RootPath));
        ((ModuleService)Mockito.doReturn(masterBranchModules).when((Object)this.moduleService)).getAllModules(this.legacyMasterBranch);
    }

    private Branch mockBranch(String branchName) {
        Branch masterBranch = (Branch)Mockito.mock(Branch.class);
        ((Branch)Mockito.doReturn((Object)branchName).when((Object)masterBranch)).getName();
        return masterBranch;
    }

    private Repository mockLegacyRepository() {
        Repository legacyRepository = (Repository)Mockito.mock(Repository.class);
        ArrayList<Branch> branches = new ArrayList<Branch>();
        branches.add(this.legacyMasterBranch);
        branches.add(this.legacyDevBranch);
        ((Repository)Mockito.doReturn(branches).when((Object)legacyRepository)).getBranches();
        ArrayList<OrganizationalUnit> ous = new ArrayList<OrganizationalUnit>();
        ous.add(this.organizationalUnit);
        ((OrganizationalUnitService)Mockito.doReturn(ous).when((Object)this.organizationalUnitService)).getOrganizationalUnits(legacyRepository);
        return legacyRepository;
    }

    private void mockRepository(OrganizationalUnit organizationalUnit) {
        ((RepositoryService)Mockito.doAnswer((Answer)new Answer<Repository>(){

            public Repository answer(InvocationOnMock invocationOnMock) throws Throwable {
                Repository newRepository = (Repository)Mockito.mock(Repository.class);
                ((Repository)Mockito.doReturn((Object)invocationOnMock.getArguments()[2]).when((Object)newRepository)).getAlias();
                ((Repository)Mockito.doReturn((Object)SpacesAPI.Scheme.FILE).when((Object)newRepository)).getScheme();
                ((Repository)Mockito.doReturn((Object)WorkspaceProjectMigrationServiceImplTest.this.space).when((Object)newRepository)).getSpace();
                return newRepository;
            }
        }).when((Object)this.repositoryService)).createRepository((OrganizationalUnit)Mockito.eq((Object)organizationalUnit), (String)Mockito.eq((Object)GitRepository.SCHEME.toString()), Mockito.anyString(), (RepositoryEnvironmentConfigurations)Mockito.any(RepositoryEnvironmentConfigurations.class));
    }

    private Module mockModule(String myOldProject, org.uberfire.backend.vfs.Path myOldProjectRootPath) {
        Module module = (Module)Mockito.mock(Module.class);
        ((Module)Mockito.doReturn((Object)myOldProject).when((Object)module)).getModuleName();
        ((Module)Mockito.doReturn((Object)myOldProjectRootPath).when((Object)module)).getRootPath();
        return module;
    }
}

