/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.HashSet;
import java.util.Set;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.ModuleRepositoriesContentHandler;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.ModuleRepositories;
import org.guvnor.common.services.project.service.ModuleRepositoriesService;
import org.guvnor.common.services.project.service.ModuleRepositoryResolver;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;

public abstract class AbstractModuleRepositoriesServiceImpl<T extends Module>
implements ModuleRepositoriesService {
    protected IOService ioService;
    protected ModuleRepositoryResolver repositoryResolver;
    protected ModuleRepositoriesContentHandler contentHandler;
    protected CommentedOptionFactory commentedOptionFactory;

    public AbstractModuleRepositoriesServiceImpl() {
    }

    public AbstractModuleRepositoriesServiceImpl(IOService ioService, ModuleRepositoryResolver repositoryResolver, ModuleRepositoriesContentHandler contentHandler, CommentedOptionFactory commentedOptionFactory) {
        this.ioService = ioService;
        this.repositoryResolver = repositoryResolver;
        this.contentHandler = contentHandler;
        this.commentedOptionFactory = commentedOptionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleRepositories create(org.uberfire.backend.vfs.Path path) {
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (this.ioService.exists(nioPath)) {
            throw new FileAlreadyExistsException(path.toString());
        }
        try {
            this.ioService.startBatch(nioPath.getFileSystem(), new Option[]{this.commentedOptionFactory.makeCommentedOption("Creating " + path.toString() + "...")});
            T project = this.getModule(path);
            HashSet<MavenRepositoryMetadata> content = new HashSet<MavenRepositoryMetadata>();
            if (project == null) {
                content.addAll(this.repositoryResolver.getRemoteRepositoriesMetaData());
            } else {
                content.addAll(this.repositoryResolver.getRemoteRepositoriesMetaData(project));
            }
            ModuleRepositories repositories = this.createProjectRepositories(content);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.contentHandler.toString(repositories), new OpenOption[0]);
            ModuleRepositories moduleRepositories = repositories;
            return moduleRepositories;
        }
        finally {
            this.ioService.endBatch();
        }
    }

    private ModuleRepositories createProjectRepositories(Set<MavenRepositoryMetadata> content) {
        HashSet<ModuleRepositories.ModuleRepository> projectRepositories = new HashSet<ModuleRepositories.ModuleRepository>();
        for (MavenRepositoryMetadata md : content) {
            projectRepositories.add(new ModuleRepositories.ModuleRepository(true, md));
        }
        ModuleRepositories repositories = new ModuleRepositories(projectRepositories);
        return repositories;
    }

    public ModuleRepositories load(org.uberfire.backend.vfs.Path path) {
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (this.ioService.exists(nioPath)) {
            String content = this.ioService.readAllString(nioPath);
            return this.contentHandler.toModel(content);
        }
        return this.create(path);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, ModuleRepositories moduleRepositories, String comment) {
        try {
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), this.contentHandler.toString(moduleRepositories), new OpenOption[0]);
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected abstract T getModule(org.uberfire.backend.vfs.Path var1);
}

