/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server.utils;

import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.guvnor.common.services.project.backend.server.utils.BuildContentHandler;
import org.guvnor.common.services.project.backend.server.utils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class BuildContentHandlerTest {
    @Test
    public void testBuildPluginUpdateExisting() throws Exception {
        org.guvnor.common.services.project.model.Build from = new org.guvnor.common.services.project.model.Build();
        from.getPlugins().add(TestUtils.makeGuvnorPlugin("myGroup", "myArtifact", "1.0"));
        Build to = new Build();
        Plugin toPlugin = TestUtils.makeMavenPlugin("myGroup", "myArtifact", "0.11.11.12");
        to.getPlugins().add(toPlugin);
        toPlugin.setGoals((Object)"someGoal");
        to.setSourceDirectory("someDirectory");
        to = new BuildContentHandler().update(from, to);
        Assert.assertEquals((long)1L, (long)to.getPlugins().size());
        Assert.assertEquals((Object)"1.0", (Object)((Plugin)to.getPlugins().get(0)).getVersion());
        Assert.assertEquals((Object)"someGoal", (Object)((Plugin)to.getPlugins().get(0)).getGoals());
        Assert.assertEquals((Object)"someDirectory", (Object)to.getSourceDirectory());
    }

    @Test
    public void testBuildPluginDeletePlugin() throws Exception {
        org.guvnor.common.services.project.model.Build from = new org.guvnor.common.services.project.model.Build();
        from.getPlugins().add(TestUtils.makeGuvnorPlugin("myGroup", "myArtifact", "1.0"));
        Build to = new Build();
        to.getPlugins().add(TestUtils.makeMavenPlugin("myGroup", "myArtifact", "1.0"));
        to.getPlugins().add(TestUtils.makeMavenPlugin("junit", "junit", "1.44"));
        to = new BuildContentHandler().update(from, to);
        Assert.assertEquals((long)1L, (long)to.getPlugins().size());
        Assert.assertEquals((Object)"1.0", (Object)((Plugin)to.getPlugins().get(0)).getVersion());
    }
}

