/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.base;

import org.uberfire.java.nio.base.LazyAttrLoader;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileTime;

public class BasicFileAttributesImpl
implements BasicFileAttributes {
    private final String fileKey;
    private final FileTime lastModifiedTime;
    private final FileTime creationTime;
    private final FileTime lastAccessTime;
    private final boolean isRegularFile;
    private final boolean isDirectory;
    private Long size = null;
    private LazyAttrLoader<Long> lazySizeLoader = null;

    public BasicFileAttributesImpl(String fileKey, FileTime lastModifiedTime, FileTime creationTime, FileTime lastAccessTime, long size, boolean isRegularFile, boolean isDirectory) {
        this.fileKey = fileKey;
        this.lastModifiedTime = lastModifiedTime;
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
        this.size = size;
        this.isRegularFile = isRegularFile;
        this.isDirectory = isDirectory;
    }

    public BasicFileAttributesImpl(String fileKey, FileTime lastModifiedTime, FileTime creationTime, FileTime lastAccessTime, LazyAttrLoader<Long> size, boolean isRegularFile, boolean isDirectory) {
        this.fileKey = fileKey;
        this.lastModifiedTime = lastModifiedTime;
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
        this.lazySizeLoader = size;
        this.isRegularFile = isRegularFile;
        this.isDirectory = isDirectory;
    }

    @Override
    public FileTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public FileTime lastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public FileTime creationTime() {
        return this.creationTime;
    }

    @Override
    public boolean isRegularFile() {
        return this.isRegularFile;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        if (this.lazySizeLoader != null) {
            return this.lazySizeLoader.get();
        }
        return this.size;
    }

    @Override
    public Object fileKey() {
        return this.fileKey;
    }
}

