/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.base;

import java.io.File;
import java.util.regex.Matcher;
import org.kie.soup.commons.validation.Preconditions;
import org.uberfire.java.nio.base.AbstractPath;
import org.uberfire.java.nio.base.SegmentedPath;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

public class GeneralPathImpl
extends AbstractPath<FileSystem>
implements SegmentedPath {
    private GeneralPathImpl(FileSystem fs, File file) {
        super(fs, file);
    }

    private GeneralPathImpl(FileSystem fs, String path, boolean isRoot, boolean isRealPath, boolean isNormalized) {
        super(fs, path, "", isRoot, isRealPath, isNormalized);
    }

    public static GeneralPathImpl newFromFile(FileSystem fs, File file) {
        Preconditions.checkNotNull((String)"fs", (Object)fs);
        Preconditions.checkNotNull((String)"file", (Object)file);
        return new GeneralPathImpl(fs, file);
    }

    public static GeneralPathImpl create(FileSystem fs, String path, boolean isRealPath) {
        return GeneralPathImpl.create(fs, path, isRealPath, false);
    }

    public static GeneralPathImpl createRoot(FileSystem fs, String path, boolean isRealPath) {
        return new GeneralPathImpl(fs, path, true, isRealPath, true);
    }

    public static GeneralPathImpl create(FileSystem fs, String path, boolean isRealPath, boolean isNormalized) {
        Preconditions.checkNotNull((String)"fs", (Object)fs);
        Preconditions.checkNotNull((String)"path", (Object)path);
        return new GeneralPathImpl(fs, path, false, isRealPath, isNormalized);
    }

    @Override
    protected AbstractPath.RootInfo setupRoot(FileSystem fs, String path, String host, boolean isRoot) {
        boolean isRooted = isRoot ? true : path.startsWith("/");
        Matcher hasWindowsDrive = WINDOWS_DRIVER.matcher(path);
        boolean isAbsolute = isRooted || hasWindowsDrive.matches();
        int lastOffset = isAbsolute ? 1 : 0;
        int windowsDriveEndsAt = -1;
        if (isAbsolute && hasWindowsDrive.matches()) {
            lastOffset = windowsDriveEndsAt = hasWindowsDrive.toMatchResult().end(1) + 1;
        }
        boolean isFinalRoot = path.length() == 1 && lastOffset == 1 ? true : (hasWindowsDrive.matches() && path.length() == windowsDriveEndsAt ? true : isRoot);
        return new AbstractPath.RootInfo(lastOffset, isAbsolute, isFinalRoot, path.getBytes());
    }

    @Override
    protected String defaultDirectory() {
        if (this.usesWindowsFormat) {
            String result = new File("").getAbsolutePath().replaceAll("/", "\\\\") + "\\";
            if (!this.hasWindowsDriver(result)) {
                return "C:" + result;
            }
            return result;
        }
        return new File("").getAbsolutePath() + "/";
    }

    private boolean hasWindowsDriver(String text) {
        Preconditions.checkNotEmpty((String)"text", (String)text);
        return WINDOWS_DRIVER.matcher(text).matches();
    }

    @Override
    protected Path newRoot(FileSystem fs, String substring, String host, boolean realPath) {
        return new GeneralPathImpl(fs, substring, true, realPath, true);
    }

    @Override
    protected Path newPath(FileSystem fs, String substring, String host, boolean isRealPath, boolean isNormalized) {
        return new GeneralPathImpl(fs, substring, false, isRealPath, isNormalized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File toFile() throws UnsupportedOperationException {
        if (this.file == null) {
            GeneralPathImpl generalPathImpl = this;
            synchronized (generalPathImpl) {
                this.file = new File(this.toString());
            }
        }
        return this.file;
    }

    @Override
    public String getSegmentId() {
        return "/";
    }
}

