/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.base;

import org.fest.assertions.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.file.FileSystem;

public class GeneralPathEqualsTest {
    final FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
    final FileSystem nfs = (FileSystem)Mockito.mock(FileSystem.class);

    @Before
    public void setup() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        Mockito.when((Object)this.nfs.getSeparator()).thenReturn((Object)"/");
    }

    @Test
    public void testEquals() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThat((Iterable)path).isEqualTo((Object)path);
        Assertions.assertThat((boolean)path.equals(new Object())).isFalse();
        Assertions.assertThat((Iterable)path).isNotEqualTo((Object)GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)true));
        Assertions.assertThat((Iterable)path).isNotEqualTo((Object)GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/file.txt", (boolean)false));
        Assertions.assertThat((Iterable)path).isNotEqualTo((Object)GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txts", (boolean)false));
        Assertions.assertThat((Iterable)path).isNotEqualTo((Object)GeneralPathImpl.create((FileSystem)this.nfs, (String)"/path/to/file.txts", (boolean)false));
        Assertions.assertThat((Iterable)path.getRoot()).isNotEqualTo((Object)path);
    }

    @Test
    public void testEqualsWindows() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/file.txt", (boolean)false);
        GeneralPathImpl wpath = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to\\file.txt", (boolean)false);
        Assertions.assertThat((Iterable)path).isNotEqualTo((Object)wpath);
    }

    @Test
    public void testHashCode() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThat((int)path.hashCode()).isEqualTo(path.hashCode());
        Assertions.assertThat((int)path.hashCode()).isNotEqualTo(new Object().hashCode());
        Assertions.assertThat((int)path.hashCode()).isNotEqualTo(GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)true).hashCode());
        Assertions.assertThat((int)path.hashCode()).isNotEqualTo(GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/file.txt", (boolean)false).hashCode());
        Assertions.assertThat((int)path.hashCode()).isNotEqualTo(GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txts", (boolean)false).hashCode());
        Assertions.assertThat((int)path.hashCode()).isNotEqualTo(GeneralPathImpl.create((FileSystem)this.nfs, (String)"/path/to/file.txts", (boolean)false).hashCode());
        Assertions.assertThat((int)path.getRoot().hashCode()).isNotEqualTo(path.hashCode());
    }

    @Test
    public void testHashCodeWindows() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/file.txt", (boolean)false);
        GeneralPathImpl wpath = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to\\file.txt", (boolean)false);
        Assertions.assertThat((int)path.hashCode()).isNotEqualTo(wpath.hashCode());
    }
}

