/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.commands.GetRef;
import org.uberfire.java.nio.fs.jgit.util.commands.Squash;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;
import org.uberfire.java.nio.fs.jgit.util.model.PathType;

public class JGitSquashingTest
extends AbstractTestInfra {
    private Logger logger = LoggerFactory.getLogger(JGitSquashingTest.class);

    @Test
    public void testSquash4Of5Commits() throws IOException, GitAPIException {
        File parentFolder = JGitSquashingTest.createTempDirectory();
        this.logger.info(">> Parent Forlder for the Test: " + parentFolder.getAbsolutePath());
        File gitFolder = new File(parentFolder, "my-local-repo.git");
        Git origin = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(origin, "master", "salaboy", "salaboy@example.com", "commit 1!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", AbstractTestInfra.tempFile("initial content file 1"));
            }
        }).execute();
        new Commit(origin, "master", "salaboy", "salaboy@example.com", "commit 2!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", AbstractTestInfra.tempFile("initial content file 2"));
            }
        }).execute();
        Iterable logs = ((GitImpl)origin)._log().setMaxCount(1).all().call();
        RevCommit secondCommit = (RevCommit)logs.iterator().next();
        new Commit(origin, "master", "salaboy", "salaboy@example.com", "commit 3!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", AbstractTestInfra.tempFile("new content file 1"));
            }
        }).execute();
        new Commit(origin, "master", "salaboy", "salaboy@example.com", "commit 4!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", AbstractTestInfra.tempFile("new content file 2"));
            }
        }).execute();
        new Commit(origin, "master", "salaboy", "salaboy@example.com", "commit 5!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file3.txt", AbstractTestInfra.tempFile("initial content file 3"));
            }
        }).execute();
        logs = ((GitImpl)origin)._log().all().call();
        int commitsCount = 0;
        for (RevCommit commit : logs) {
            this.logger.info(">>> Origin Commit: " + commit.getFullMessage() + " - " + commit.toString());
            ++commitsCount;
        }
        Assertions.assertThat((int)commitsCount).isEqualTo(5);
        Assertions.assertThat((Comparable)origin.getPathInfo("master", "pathx/").getPathType()).isEqualTo((Object)PathType.NOT_FOUND);
        Assertions.assertThat((Comparable)origin.getPathInfo("master", "path/to/file1.txt").getPathType()).isEqualTo((Object)PathType.FILE);
        Assertions.assertThat((Comparable)origin.getPathInfo("master", "path/to/file2.txt").getPathType()).isEqualTo((Object)PathType.FILE);
        Assertions.assertThat((Comparable)origin.getPathInfo("master", "path/to/file3.txt").getPathType()).isEqualTo((Object)PathType.FILE);
        Assertions.assertThat((Comparable)origin.getPathInfo("master", "path/to").getPathType()).isEqualTo((Object)PathType.DIRECTORY);
        this.logger.info("Squashing from " + secondCommit.getName() + "  to HEAD");
        new Squash((GitImpl)origin, "master", secondCommit.getName(), "squashed message").execute();
        commitsCount = 0;
        for (RevCommit commit : ((GitImpl)origin)._log().all().call()) {
            this.logger.info(">>> Final Commit: " + commit.getFullMessage() + " - " + commit.toString());
            ++commitsCount;
        }
        Assertions.assertThat((int)commitsCount).isEqualTo(2);
    }

    @Test
    public void testFailWhenTryToSquashCommitsFromDifferentBranches() throws IOException, GitAPIException {
        File parentFolder = JGitSquashingTest.createTempDirectory();
        this.logger.info(">> Parent Forlder for the Test: " + parentFolder.getAbsolutePath());
        File gitFolder = new File(parentFolder, "my-local-repo.git");
        Git origin = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(origin, "master", "aparedes", "aparedes@example.com", "commit 1!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", AbstractTestInfra.tempFile("initial content file 1"));
            }
        }).execute();
        new Commit(origin, "develop", "salaboy", "salaboy@example.com", "commit 2!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", AbstractTestInfra.tempFile("initial content file 2"));
            }
        }).execute();
        new Commit(origin, "master", "aparedes", "aparedes@example.com", "commit 3!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file3.txt", AbstractTestInfra.tempFile("initial content file 1"));
            }
        }).execute();
        new Commit(origin, "master", "aparedes", "aparedes@example.com", "commit 4!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file4.txt", AbstractTestInfra.tempFile("initial content file 1"));
            }
        }).execute();
        List<RevCommit> masterCommits = this.getCommitsFromBranch((GitImpl)origin, "master");
        List<RevCommit> developCommits = this.getCommitsFromBranch((GitImpl)origin, "develop");
        Assertions.assertThat((int)masterCommits.size()).isEqualTo(3);
        Assertions.assertThat((int)developCommits.size()).isEqualTo(1);
        try {
            new Squash((GitImpl)origin, "master", developCommits.get(0).getName(), "squashed message").execute();
            Assertions.fail((String)"If it reaches here the test has failed because he found the commit into the branch");
        }
        catch (GitException e) {
            this.logger.info(e.getMessage());
            Assertions.assertThat((Throwable)e).isNotNull();
        }
    }

    private List<RevCommit> getCommitsFromBranch(GitImpl origin, String branch) throws GitAPIException, MissingObjectException, IncorrectObjectTypeException {
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        ObjectId id = new GetRef(origin.getRepository(), branch).execute().getObjectId();
        for (RevCommit commit : origin._log().add((AnyObjectId)id).call()) {
            this.logger.info(">>> " + branch + " Commits: " + commit.getFullMessage() + " - " + commit.toString());
            commits.add(commit);
        }
        return commits;
    }

    @Test
    public void testSquashCommitsWithDifferentPaths() throws IOException, GitAPIException {
        File parentFolder = JGitSquashingTest.createTempDirectory();
        this.logger.info(">> Parent Folder for the Test: " + parentFolder.getAbsolutePath());
        File gitFolder = new File(parentFolder, "my-local-repo.git");
        Git origin = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(origin, "master", "salaboy", "salaboy@example.com", "commit 1!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", AbstractTestInfra.tempFile("initial content file 1"));
            }
        }).execute();
        new Commit(origin, "master", "salaboy", "salaboy@example.com", "commit 2!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", AbstractTestInfra.tempFile("initial content file 2"));
            }
        }).execute();
        Iterable logs = ((GitImpl)origin)._log().setMaxCount(1).all().call();
        RevCommit secondCommit = (RevCommit)logs.iterator().next();
        new Commit(origin, "master", "salaboy", "salaboy@example.com", "commit 3!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", AbstractTestInfra.tempFile("new content file 1"));
            }
        }).execute();
        new Commit(origin, "master", "salaboy", "salaboy@example.com", "commit 4!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", AbstractTestInfra.tempFile("new content file 2"));
            }
        }).execute();
        new Commit(origin, "master", "salaboy", "salaboy@example.com", "commit 5!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/file3.txt", AbstractTestInfra.tempFile("initial content file 3"));
            }
        }).execute();
        for (RevCommit commit : ((GitImpl)origin)._log().all().call()) {
            this.logger.info(">>> Origin Commit: " + commit.getFullMessage() + " - " + commit.toString());
        }
        Assertions.assertThat((Comparable)origin.getPathInfo("master", "pathx/").getPathType()).isEqualTo((Object)PathType.NOT_FOUND);
        Assertions.assertThat((Comparable)origin.getPathInfo("master", "file1.txt").getPathType()).isEqualTo((Object)PathType.FILE);
        Assertions.assertThat((Comparable)origin.getPathInfo("master", "path/to/file2.txt").getPathType()).isEqualTo((Object)PathType.FILE);
        Assertions.assertThat((Comparable)origin.getPathInfo("master", "path/file3.txt").getPathType()).isEqualTo((Object)PathType.FILE);
        Assertions.assertThat((Comparable)origin.getPathInfo("master", "path/to").getPathType()).isEqualTo((Object)PathType.DIRECTORY);
        this.logger.info("Squashing from " + secondCommit.getName() + "  to HEAD");
        new Squash((GitImpl)origin, "master", secondCommit.getName(), "squashed message").execute();
        int commitsCount = 0;
        for (RevCommit commit : ((GitImpl)origin)._log().all().call()) {
            this.logger.info(">>> Final Commit: " + commit.getFullMessage() + " - " + commit.toString());
            ++commitsCount;
        }
        Assertions.assertThat((int)commitsCount).isEqualTo(2);
    }

    static {
        CredentialsProvider.setDefault((CredentialsProvider)new UsernamePasswordCredentialsProvider("guest", ""));
    }
}

