/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.revwalk.RevCommit;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class JGitMapDiffContentTest
extends AbstractTestInfra {
    private Git git;
    private static final String MASTER_BRANCH = "master";
    private static final List<String> TXT_FILES = Stream.of("file0", "file1", "file2", "file3", "file4").collect(Collectors.toList());
    private static final String[] COMMON_TXT_LINES = new String[]{"Line1", "Line2", "Line3", "Line4"};

    @Before
    public void setup() throws IOException {
        File parentFolder = JGitMapDiffContentTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        this.git = (Git)new CreateRepository(gitSource).execute().get();
        JGitMapDiffContentTest.commit(this.git, MASTER_BRANCH, "Adding files into master", JGitMapDiffContentTest.content(TXT_FILES.get(0), JGitMapDiffContentTest.multiline(TXT_FILES.get(0), COMMON_TXT_LINES)), JGitMapDiffContentTest.content(TXT_FILES.get(1), JGitMapDiffContentTest.multiline(TXT_FILES.get(1), COMMON_TXT_LINES)), JGitMapDiffContentTest.content(TXT_FILES.get(2), JGitMapDiffContentTest.multiline(TXT_FILES.get(2), COMMON_TXT_LINES)));
    }

    @Test
    public void testNoDiffOnlyOneCommit() throws IOException {
        Map content = this.git.mapDiffContent(MASTER_BRANCH, this.git.getFirstCommit(this.git.getRef(MASTER_BRANCH)).getName(), this.git.getLastCommit(this.git.getRef(MASTER_BRANCH)).getName());
        Assertions.assertThat((Map)content).isEmpty();
    }

    @Test
    public void testHasContent() throws IOException {
        JGitMapDiffContentTest.commit(this.git, MASTER_BRANCH, "Adding file into master", JGitMapDiffContentTest.content(TXT_FILES.get(4), JGitMapDiffContentTest.multiline(TXT_FILES.get(4), COMMON_TXT_LINES)));
        Map contents = this.git.mapDiffContent(MASTER_BRANCH, this.git.getFirstCommit(this.git.getRef(MASTER_BRANCH)).getName(), this.git.getLastCommit(this.git.getRef(MASTER_BRANCH)).getName());
        Assertions.assertThat((Map)contents).isNotEmpty();
        Assertions.assertThat((Map)contents).hasSize(1);
    }

    @Test
    public void testHasContents() throws IOException {
        JGitMapDiffContentTest.commit(this.git, MASTER_BRANCH, "Adding files into master", JGitMapDiffContentTest.content(TXT_FILES.get(3), JGitMapDiffContentTest.multiline(TXT_FILES.get(3), COMMON_TXT_LINES)), JGitMapDiffContentTest.content(TXT_FILES.get(4), JGitMapDiffContentTest.multiline(TXT_FILES.get(4), COMMON_TXT_LINES)));
        Map contents = this.git.mapDiffContent(MASTER_BRANCH, this.git.getFirstCommit(this.git.getRef(MASTER_BRANCH)).getName(), this.git.getLastCommit(this.git.getRef(MASTER_BRANCH)).getName());
        Assertions.assertThat((Map)contents).isNotEmpty();
        Assertions.assertThat((Map)contents).hasSize(2);
    }

    @Test
    public void testHasDeleteContents() throws IOException {
        new Commit(this.git, MASTER_BRANCH, "name", "name@example.com", "Removing file", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put(TXT_FILES.get(0), null);
            }
        }).execute();
        new Commit(this.git, MASTER_BRANCH, "name", "name@example.com", "Removing file", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put(TXT_FILES.get(1), null);
            }
        }).execute();
        Map contents = this.git.mapDiffContent(MASTER_BRANCH, this.git.getFirstCommit(this.git.getRef(MASTER_BRANCH)).getName(), this.git.getLastCommit(this.git.getRef(MASTER_BRANCH)).getName());
        Assertions.assertThat((Map)contents).isNotEmpty();
        Assertions.assertThat((Map)contents).hasSize(2);
        contents.values().forEach(v -> Assertions.assertThat((File)v).isNull());
    }

    @Test
    public void testWithManyCommitsOneFile() throws IOException {
        JGitMapDiffContentTest.commit(this.git, MASTER_BRANCH, "Updating a file", JGitMapDiffContentTest.content(TXT_FILES.get(0), "update 1"));
        JGitMapDiffContentTest.commit(this.git, MASTER_BRANCH, "Updating a file", JGitMapDiffContentTest.content(TXT_FILES.get(0), "update 2"));
        JGitMapDiffContentTest.commit(this.git, MASTER_BRANCH, "Updating a file", JGitMapDiffContentTest.content(TXT_FILES.get(0), "update 3"));
        Map contents = this.git.mapDiffContent(MASTER_BRANCH, this.git.getFirstCommit(this.git.getRef(MASTER_BRANCH)).getName(), this.git.getLastCommit(this.git.getRef(MASTER_BRANCH)).getName());
        Assertions.assertThat((Map)contents).isNotEmpty();
        Assertions.assertThat((Map)contents).hasSize(1);
    }

    @Test
    public void testWithMiddleCommits() throws IOException {
        JGitMapDiffContentTest.commit(this.git, MASTER_BRANCH, "Updating a file", JGitMapDiffContentTest.content(TXT_FILES.get(0), "update 1"));
        RevCommit startCommit = this.git.getLastCommit(MASTER_BRANCH);
        JGitMapDiffContentTest.commit(this.git, MASTER_BRANCH, "Adding files into master", JGitMapDiffContentTest.content(TXT_FILES.get(3), JGitMapDiffContentTest.multiline(TXT_FILES.get(3), COMMON_TXT_LINES)), JGitMapDiffContentTest.content(TXT_FILES.get(4), JGitMapDiffContentTest.multiline(TXT_FILES.get(4), COMMON_TXT_LINES)));
        new Commit(this.git, MASTER_BRANCH, "name", "name@example.com", "Removing file", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put(TXT_FILES.get(1), null);
            }
        }).execute();
        RevCommit endCommit = this.git.getLastCommit(MASTER_BRANCH);
        JGitMapDiffContentTest.commit(this.git, MASTER_BRANCH, "Updating a file", JGitMapDiffContentTest.content(TXT_FILES.get(0), "update 3"));
        Map contents = this.git.mapDiffContent(MASTER_BRANCH, startCommit.getName(), endCommit.getName());
        Assertions.assertThat((Map)contents).isNotEmpty();
        Assertions.assertThat((Map)contents).hasSize(3);
    }

    @Test(expected=GitException.class)
    public void testWithWrongBranchName() throws IOException {
        this.git.mapDiffContent("wrong-branch-name", this.git.getFirstCommit(this.git.getRef(MASTER_BRANCH)).getName(), this.git.getLastCommit(this.git.getRef(MASTER_BRANCH)).getName());
    }

    @Test(expected=GitException.class)
    public void testWithInvalidCommit() throws IOException {
        this.git.mapDiffContent(MASTER_BRANCH, "invalid-commit-id", this.git.getLastCommit(this.git.getRef(MASTER_BRANCH)).getName());
    }
}

