/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.Clone;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.commands.Fork;
import org.uberfire.java.nio.fs.jgit.util.commands.ListRefs;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class JGitForkTest
extends AbstractTestInfra {
    private static final String TARGET_GIT = "target/target";
    private static final String SOURCE_GIT = "source/source";
    private static Logger logger = LoggerFactory.getLogger(JGitForkTest.class);

    @Test
    public void testToForkSuccess() throws IOException, GitAPIException {
        File parentFolder = JGitForkTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "user_branch", "name", "name@example.com", "commit!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", AbstractTestInfra.tempFile("temp2222"));
            }
        }).execute();
        new Commit(origin, "master", "name", "name@example.com", "commit", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", AbstractTestInfra.tempFile("temp"));
            }
        }).execute();
        new Commit(origin, "master", "name", "name@example.com", "commit", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", AbstractTestInfra.tempFile("temp3"));
            }
        }).execute();
        new Fork(parentFolder, SOURCE_GIT, TARGET_GIT, null, CredentialsProvider.getDefault(), null, null).execute();
        File gitCloned = new File(parentFolder, "target/target.git");
        Git cloned = Git.createRepository((File)gitCloned);
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((List)new ListRefs(cloned.getRepository()).execute()).hasSize(2);
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(0)).getName()).isEqualTo("refs/heads/master");
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(1)).getName()).isEqualTo("refs/heads/user_branch");
        String remotePath = new File(((URIish)((RemoteConfig)((GitImpl)cloned)._remoteList().call().get(0)).getURIs().get(0)).getPath()).getAbsolutePath();
        Assertions.assertThat((String)remotePath).isEqualTo(new File(gitSource.getPath()).getAbsolutePath());
    }

    @Test(expected=GitException.class)
    public void testToForkAlreadyExists() throws IOException, GitAPIException {
        File parentFolder = JGitForkTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "master", "name", "name@example.com", "commit", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", AbstractTestInfra.tempFile("temp"));
            }
        }).execute();
        File gitTarget = new File(parentFolder, "target/target.git");
        Git originTarget = (Git)new CreateRepository(gitTarget).execute().get();
        new Commit(originTarget, "master", "name", "name@example.com", "commit", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", AbstractTestInfra.tempFile("temp"));
            }
        }).execute();
        new Fork(parentFolder, SOURCE_GIT, TARGET_GIT, null, CredentialsProvider.getDefault(), null, null).execute();
    }

    @Test
    public void testToForkWrongSource() throws IOException {
        File parentFolder = JGitForkTest.createTempDirectory();
        try {
            new Fork(parentFolder, SOURCE_GIT, TARGET_GIT, null, CredentialsProvider.getDefault(), null, null).execute();
            Assertions.fail((String)"If got here is because it could for the repository");
        }
        catch (Clone.CloneException e) {
            Assertions.assertThat((Throwable)e).isNotNull();
            logger.info(e.getMessage(), (Throwable)e);
        }
    }

    @Test
    public void testForkRepository() throws GitAPIException {
        final String SOURCE = "testforkA/source";
        String TARGET = "testforkB/target";
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        };
        String sourcePath = "git://" + SOURCE;
        URI sourceUri = URI.create(sourcePath);
        this.provider.newFileSystem(sourceUri, (Map)env);
        HashMap<String, Object> forkEnv = new HashMap<String, Object>(){
            {
                this.put("origin", SOURCE);
            }
        };
        String forkPath = "git://" + TARGET;
        URI forkUri = URI.create(forkPath);
        JGitFileSystem fs = (JGitFileSystem)this.provider.newFileSystem(forkUri, (Map)forkEnv);
        Assertions.assertThat((String)((URIish)((RemoteConfig)((GitImpl)fs.getGit())._remoteList().call().get(0)).getURIs().get(0)).toString()).isEqualTo(new File(this.provider.getGitRepoContainerDir(), SOURCE + ".git").toPath().toUri().toString());
    }

    @Test(expected=FileSystemAlreadyExistsException.class)
    public void testForkRepositoryThatAlreadyExists() {
        final String SOURCE = "testforkA/source";
        String TARGET = "testforkB/target";
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        };
        String sourcePath = "git://" + SOURCE;
        URI sourceUri = URI.create(sourcePath);
        this.provider.newFileSystem(sourceUri, (Map)env);
        HashMap<String, Object> forkEnv = new HashMap<String, Object>(){
            {
                this.put("origin", SOURCE);
            }
        };
        String forkPath = "git://" + TARGET;
        URI forkUri = URI.create(forkPath);
        this.provider.newFileSystem(forkUri, (Map)forkEnv);
        this.provider.newFileSystem(forkUri, (Map)forkEnv);
    }

    @Test
    public void testForkWithoutHookDirShouldNotBeUpdatedAfterGitHookDirAdded() throws IOException, GitAPIException {
        File hooksDir = JGitForkTest.createTempDirectory();
        File parentFolder = JGitForkTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        this.writeMockHook(hooksDir, "post-commit");
        this.writeMockHook(hooksDir, "pre-commit");
        Git repo = (Git)new CreateRepository(gitSource, null).execute().get();
        Git existentRepoWithHookDirDefined = (Git)new CreateRepository(gitSource, hooksDir).execute().get();
        Object[] hooks = new File(existentRepoWithHookDirDefined.getRepository().getDirectory(), "hooks").listFiles();
        Assertions.assertThat((Object[])hooks).isEmpty();
    }

    @Test
    public void testForkWithHookDir() throws IOException, GitAPIException {
        File hooksDir = JGitForkTest.createTempDirectory();
        this.writeMockHook(hooksDir, "post-commit");
        this.writeMockHook(hooksDir, "pre-commit");
        File parentFolder = JGitForkTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource, hooksDir).execute().get();
        new Commit(origin, "user_branch", "name", "name@example.com", "commit!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", AbstractTestInfra.tempFile("temp2222"));
            }
        }).execute();
        Git cloned = new Fork(parentFolder, SOURCE_GIT, TARGET_GIT, null, CredentialsProvider.getDefault(), null, hooksDir).execute();
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((List)new ListRefs(cloned.getRepository()).execute()).hasSize(1);
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(0)).getName()).isEqualTo("refs/heads/user_branch");
        String remotePath = new File(((URIish)((RemoteConfig)((GitImpl)cloned)._remoteList().call().get(0)).getURIs().get(0)).getPath()).getAbsolutePath();
        Assertions.assertThat((String)remotePath).isEqualTo(new File(gitSource.getPath()).getAbsolutePath());
        boolean foundPreCommitHook = false;
        boolean foundPostCommitHook = false;
        Object[] hooks = new File(cloned.getRepository().getDirectory(), "hooks").listFiles();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])hooks).isNotEmpty()).isNotNull();
        Assertions.assertThat((int)hooks.length).isEqualTo(2);
        for (Object hook : hooks) {
            if (((File)hook).getName().equals("pre-commit")) {
                foundPreCommitHook = ((File)hook).canExecute();
                continue;
            }
            if (!((File)hook).getName().equals("post-commit")) continue;
            foundPostCommitHook = ((File)hook).canExecute();
        }
        Assertions.assertThat((boolean)foundPreCommitHook).isTrue();
        Assertions.assertThat((boolean)foundPostCommitHook).isTrue();
    }

    @Test
    public void testForkMultipleBranches() throws Exception {
        File parentFolder = JGitForkTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource, null).execute().get();
        JGitForkTest.commit(origin, "master", "first", JGitForkTest.content("dir1/file.txt", "foo"), JGitForkTest.content("dir2/file2.txt", "bar"), JGitForkTest.content("file3.txt", "moogah"));
        this.branch(origin, "master", "dev");
        JGitForkTest.commit(origin, "dev", "second", JGitForkTest.content("dir1/file.txt", "foo1"), JGitForkTest.content("file3.txt", "bar1"));
        this.branch(origin, "master", "ignored");
        JGitForkTest.commit(origin, "ignored", "third", JGitForkTest.content("dir1/file.txt", "foo2"));
        Git cloned = new Fork(parentFolder, SOURCE_GIT, TARGET_GIT, Arrays.asList("master", "dev"), CredentialsProvider.getDefault(), null, null).execute();
        Assertions.assertThat((Object)cloned).isNotNull();
        Set clonedRefs = this.listRefs(cloned).stream().map(ref -> ref.getName()).collect(Collectors.toSet());
        Assertions.assertThat(clonedRefs).hasSize(2);
        Assertions.assertThat(clonedRefs).containsExactly((Object[])new String[]{"refs/heads/master", "refs/heads/dev"});
    }
}

