/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.infinispan.suite;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class InfinispanTestProperties {
    public static final String VERSION = "version";
    public static final String IMAGE = "image";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String ISPN_PROPERTIES = "ispn.properties";
    private final Properties props;

    public static InfinispanTestProperties getInstance() {
        return LazyHolder.INSTANCE;
    }

    InfinispanTestProperties() {
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream(ISPN_PROPERTIES);
        this.props = new Properties();
        try {
            this.props.load(resource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getProp(String key, Properties props) {
        Properties systemProps = System.getProperties();
        String prop = systemProps.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)prop)) {
            prop = props.getProperty(key);
        }
        return prop;
    }

    public String getVersion() {
        return this.getProp(VERSION, this.props);
    }

    public String getImage() {
        return this.getProp(IMAGE, this.props);
    }

    public String getUser() {
        return this.getProp(USER, this.props);
    }

    public String getPassword() {
        return this.getProp(PASSWORD, this.props);
    }

    private static class LazyHolder {
        static final InfinispanTestProperties INSTANCE = new InfinispanTestProperties();

        private LazyHolder() {
        }
    }
}

